/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.frame.OpaqueRequestFrame;
import io.kroxylicious.proxy.frame.RequestFrame;
import io.kroxylicious.proxy.internal.ApiVersionsServiceImpl;
import io.kroxylicious.proxy.internal.codec.BodyDecoder;
import io.kroxylicious.proxy.internal.codec.ByteBufAccessorImpl;
import io.kroxylicious.proxy.internal.codec.DecodePredicate;
import io.kroxylicious.proxy.internal.codec.KafkaMessageDecoder;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.kroxylicious.proxy.internal.filter.ApiVersionsDowngradeFilter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRequestDecoder
extends KafkaMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaRequestDecoder.class);
    private final DecodePredicate decodePredicate;
    private final ApiVersionsServiceImpl apiVersionsService;

    public KafkaRequestDecoder(DecodePredicate decodePredicate, int socketFrameMaxSize, ApiVersionsServiceImpl apiVersionsService, @Nullable KafkaMessageListener listener) {
        super(socketFrameMaxSize, listener);
        this.decodePredicate = decodePredicate;
        this.apiVersionsService = apiVersionsService;
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    protected Frame decodeHeaderAndBody(ChannelHandlerContext ctx, ByteBuf in, int length) {
        RequestFrame frame;
        ByteBufAccessorImpl accessor;
        int sof = in.readerIndex();
        short apiId = in.readShort();
        ApiKeys apiKey = ApiKeys.forId((int)apiId);
        if (this.log().isTraceEnabled()) {
            this.log().trace("{}: apiKey: {} {}", new Object[]{ctx, apiId, apiKey});
        }
        short apiVersion = in.readShort();
        if (this.log().isTraceEnabled()) {
            this.log().trace("{}: apiVersion: {}", (Object)ctx, (Object)apiVersion);
        }
        int startOfMessage = in.readerIndex();
        int correlationId = in.readInt();
        LOGGER.debug("{}: {} downstream correlation id: {}", new Object[]{ctx, apiKey, correlationId});
        boolean decodeRequest = this.decodePredicate.shouldDecodeRequest(apiKey, apiVersion);
        LOGGER.debug("Decode {}/v{} request? {}, Predicate {} ", new Object[]{apiKey, apiVersion, decodeRequest, this.decodePredicate});
        boolean decodeResponse = this.decodePredicate.shouldDecodeResponse(apiKey, apiVersion);
        LOGGER.debug("Decode {}/v{} response? {}, Predicate {}", new Object[]{apiKey, apiVersion, decodeResponse, this.decodePredicate});
        short headerVersion = apiKey.requestHeaderVersion(apiVersion);
        RequestHeaderData header = null;
        if (decodeRequest) {
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: headerVersion {}", (Object)ctx, (Object)headerVersion);
            }
            in.readerIndex(sof);
            accessor = new ByteBufAccessorImpl(in);
            header = this.readHeader(headerVersion, accessor);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: header: {}", (Object)ctx, (Object)header);
            }
        } else {
            accessor = null;
        }
        if (decodeRequest) {
            boolean clientAheadOfProxy;
            short highestProxyVersion = this.apiVersionsService.latestVersion(apiKey);
            boolean bl = clientAheadOfProxy = apiVersion > highestProxyVersion;
            if (clientAheadOfProxy) {
                if (apiKey == ApiKeys.API_VERSIONS) {
                    return this.createV0ApiVersionRequestFrame(ctx, correlationId);
                }
                this.log().error("{}: apiVersion {} for {} ahead of proxy maximum: {}", new Object[]{ctx, apiVersion, apiKey, highestProxyVersion});
                throw new IllegalStateException("client apiVersion " + apiVersion + " ahead of proxy maximum " + highestProxyVersion + " for api key: " + String.valueOf(apiKey));
            }
            ApiMessage body = BodyDecoder.decodeRequest(apiKey, apiVersion, accessor);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: body {}", (Object)ctx, (Object)body);
            }
            frame = new DecodedRequestFrame<ApiMessage>(apiVersion, correlationId, decodeResponse, header, body);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: frame {}", (Object)ctx, (Object)frame);
            }
        } else {
            boolean hasResponse = true;
            if (apiKey == ApiKeys.PRODUCE) {
                short acks = KafkaRequestDecoder.readAcks(in, startOfMessage, apiKey.id, apiVersion);
                hasResponse = acks != 0;
            }
            in.readerIndex(sof);
            frame = this.opaqueFrame(in, apiId, apiVersion, correlationId, decodeResponse, length, hasResponse);
            in.readerIndex(sof + length);
        }
        return frame;
    }

    private DecodedRequestFrame<ApiVersionsRequestData> createV0ApiVersionRequestFrame(ChannelHandlerContext ctx, int correlationId) {
        if (this.log().isTraceEnabled()) {
            this.log().trace("{}: downgrading apiVersion request to v0", (Object)ctx);
        }
        return ApiVersionsDowngradeFilter.downgradeApiVersionsFrame(correlationId);
    }

    private static void incrementReaderIndex(ByteBuf byteBuf, int increment) {
        byteBuf.readerIndex(byteBuf.readerIndex() + increment);
    }

    static short readAcks(ByteBuf in, int startOfMessage, short apiKey, short apiVersion) {
        in.readerIndex(startOfMessage);
        short headerVersion = ApiKeys.forId((int)apiKey).requestHeaderVersion(apiVersion);
        KafkaRequestDecoder.incrementReaderIndex(in, 4);
        if (headerVersion >= 1) {
            short clientIdLength = in.readShort();
            KafkaRequestDecoder.incrementReaderIndex(in, clientIdLength);
        }
        if (headerVersion >= 2) {
            int numTaggedFields = ByteBufAccessorImpl.readUnsignedVarint(in);
            for (int i = 0; i < numTaggedFields; ++i) {
                ByteBufAccessorImpl.readUnsignedVarint(in);
                int size = ByteBufAccessorImpl.readUnsignedVarint(in);
                KafkaRequestDecoder.incrementReaderIndex(in, size);
            }
        }
        if (apiVersion >= 3) {
            int transactionIdLength;
            if (apiVersion < 9) {
                transactionIdLength = in.readShort();
            } else if (apiVersion <= 12) {
                transactionIdLength = ByteBufAccessorImpl.readUnsignedVarint(in);
            } else {
                throw new AssertionError((Object)("Unsupported Produce apiVersion: " + apiVersion));
            }
            KafkaRequestDecoder.incrementReaderIndex(in, transactionIdLength);
        }
        short acks = in.readShort();
        return acks;
    }

    private OpaqueRequestFrame opaqueFrame(ByteBuf in, short apiKey, short apiVersion, int correlationId, boolean decodeResponse, int length, boolean hasResponse) {
        return new OpaqueRequestFrame(in.readSlice(length).retain(), apiKey, apiVersion, correlationId, decodeResponse, length, hasResponse);
    }

    private RequestHeaderData readHeader(short headerVersion, Readable accessor) {
        return new RequestHeaderData(accessor, headerVersion);
    }
}

