/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.frame.RequestFrame;
import io.kroxylicious.proxy.internal.InternalRequestFrame;
import io.kroxylicious.proxy.internal.codec.CorrelationManager;
import io.kroxylicious.proxy.internal.codec.KafkaMessageEncoder;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRequestEncoder
extends KafkaMessageEncoder<RequestFrame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaRequestEncoder.class);
    public static final int LENGTH = 4;
    public static final int API_KEY = 2;
    public static final int API_VERSION = 2;
    private final CorrelationManager correlationManager;

    public KafkaRequestEncoder(CorrelationManager correlationManager, @Nullable KafkaMessageListener listener) {
        super(listener);
        this.correlationManager = correlationManager;
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, RequestFrame frame, ByteBuf out) throws Exception {
        super.encode(ctx, frame, out);
        int wi = out.writerIndex();
        short apiKey = frame.apiKeyId();
        short apiVersion = frame.apiVersion();
        boolean hasResponse = frame.hasResponse();
        boolean decodeResponse = frame.decodeResponse();
        int downstreamCorrelationId = frame.correlationId();
        int upstreamCorrelationId = this.correlationManager.putBrokerRequest(apiKey, apiVersion, downstreamCorrelationId, hasResponse, frame instanceof InternalRequestFrame ? ((InternalRequestFrame)frame).recipient() : null, frame instanceof InternalRequestFrame ? ((InternalRequestFrame)frame).promise() : null, decodeResponse);
        out.writerIndex(8);
        out.writeInt(upstreamCorrelationId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: {} downstream correlation id {} assigned upstream correlation id: {}", new Object[]{ctx, ApiKeys.forId((int)apiKey), downstreamCorrelationId, upstreamCorrelationId});
        }
        out.writerIndex(wi);
    }
}

