/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferOutputStream;

public class ByteBufOutputStream
extends ByteBufferOutputStream {
    private static final ByteBuffer DUMMY = ByteBuffer.allocate(0);
    private final int initialCapacity;
    private final int initialPosition;
    private final ByteBuf byteBuf;
    private ByteBuffer nioBuffer;

    public ByteBufOutputStream(ByteBuf byteBuf) {
        super(DUMMY);
        if (byteBuf.nioBufferCount() != 1) {
            throw new IllegalArgumentException("Composite buffers are not supported");
        }
        this.byteBuf = byteBuf;
        this.nioBuffer = byteBuf.nioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
        this.initialPosition = byteBuf.writerIndex();
        this.initialCapacity = this.nioBuffer.capacity();
    }

    public void write(int b) {
        this.ensureRemaining(1);
        this.byteBuf.writeByte(b);
        this.nioBuffer.position(this.nioBuffer.position() + 1);
    }

    public void write(byte[] bytes, int off, int len) {
        this.ensureRemaining(len);
        this.byteBuf.writeBytes(bytes, off, len);
        this.nioBuffer.position(this.nioBuffer.position() + len);
    }

    public void write(ByteBuffer sourceBuffer) {
        int writtenBytes = sourceBuffer.remaining();
        this.ensureRemaining(writtenBytes);
        this.byteBuf.writeBytes(sourceBuffer);
        this.nioBuffer.position(this.nioBuffer.position() + writtenBytes);
    }

    public ByteBuffer buffer() {
        return this.nioBuffer;
    }

    public ByteBuf byteBuf() {
        return this.byteBuf;
    }

    public int position() {
        return this.nioBuffer.position();
    }

    public int remaining() {
        return this.nioBuffer.remaining();
    }

    public int limit() {
        return this.nioBuffer.limit();
    }

    public void position(int position) {
        int delta = position - this.nioBuffer.position();
        this.ensureRemaining(delta);
        this.nioBuffer.position(position);
        this.byteBuf.writerIndex(this.byteBuf.writerIndex() + delta);
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public void ensureRemaining(int remainingBytesRequired) {
        if (remainingBytesRequired > this.byteBuf.writableBytes()) {
            this.expandByteBuffer(remainingBytesRequired);
        }
    }

    private void expandByteBuffer(int remainingRequired) {
        this.byteBuf.ensureWritable(remainingRequired);
        int position = this.nioBuffer.position();
        this.nioBuffer.position(0);
        this.nioBuffer = this.byteBuf.nioBuffer(this.initialPosition, this.byteBuf.capacity());
        this.nioBuffer.position(position);
    }
}

