/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableKroxyliciousLinkGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StableKroxyliciousLinkGenerator.class);
    public static final StableKroxyliciousLinkGenerator INSTANCE = new StableKroxyliciousLinkGenerator();
    public static final String CLIENT_TLS = "clientTls";
    private final LinkInfo links;

    StableKroxyliciousLinkGenerator() {
        this(() -> {
            LOGGER.info("loading links from: classpath:META-INF/stablelinks.properties");
            return StableKroxyliciousLinkGenerator.class.getClassLoader().getResourceAsStream("META-INF/stablelinks.properties");
        });
    }

    StableKroxyliciousLinkGenerator(Supplier<InputStream> propLoader) {
        this.links = this.loadLinks(propLoader);
    }

    public String errorLink(String slug) {
        return this.links.generateLink("errors", slug);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LinkInfo loadLinks(Supplier<InputStream> propLoader) {
        try (InputStream resource = propLoader.get();){
            if (resource == null) return new LinkInfo(Map.of());
            Properties properties = new Properties();
            properties.load(resource);
            LinkInfo linkInfo = new LinkInfo(properties);
            return linkInfo;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private record LinkInfo(Map<String, String> properties) {
        LinkInfo(Properties properties) {
            this(properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
        }

        public String generateLink(String namespace, String slug) {
            String lookupKey = "%s.%s".formatted(namespace, slug);
            if (this.properties.containsKey(lookupKey)) {
                return this.properties.get(lookupKey);
            }
            throw new IllegalArgumentException("No link found for " + lookupKey);
        }
    }
}

