/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import io.confluent.csid.config.provider.common.AbstractConfigProviderConfig;
import io.confluent.csid.config.provider.common.config.ConfigKeyBuilder;
import io.confluent.csid.config.provider.common.config.ConfigUtils;
import io.confluent.csid.config.provider.common.config.Recommenders;
import io.confluent.csid.config.provider.common.config.Validators;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyVaultConfigProviderConfig
extends AbstractConfigProviderConfig {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultConfigProviderConfig.class);
    public static final String PREFIX_CONFIG = "secret.prefix";
    static final String PREFIX_DOC = "Sets a prefix that will be added to all paths. For example you can use `staging` or `production` and all of the calls to Secrets Manager will be prefixed with that path. This allows the same configuration settings to be used across multiple environments.";
    public static final String CREDENTIAL_TYPE_CONFIG = "credential.type";
    public static final String CREDENTIAL_TYPE_DOC = "The type of credentials to use. " + ConfigUtils.enumDescription(CredentialLocation.class, (Enum[])new CredentialLocation[0]);
    public static final String CERTIFICATE_PATH_CONFIG = "client.certificate.path";
    public static final String CERTIFICATE_PATH_DOC = "Location on the local filesystem for the client certificate that will be used to authenticate to Azure.";
    public static final String CERTIFICATE_TYPE_CONFIG = "client.certificate.type";
    public static final String CERTIFICATE_TYPE_DOC = "The type of encoding used on the file specified in `client.certificate.path`. " + ConfigUtils.enumDescription(ClientCertificateType.class, (Enum[])new ClientCertificateType[0]);
    public static final String CERTIFICATE_PFX_PASSWORD_CONFIG = "client.certificate.pfx.password";
    public static final String CERTIFICATE_PFX_PASSWORD_DOC = "The password protecting the PFX file.";
    public static final String CERTIFICATE_SEND_CHAIN_CONFIG = "client.certificate.send.certificate.chain.enabled";
    public static final String CERTIFICATE_SEND_CHAIN_DOC = "Flag to indicate if certificate chain should be sent as part of authentication request.";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String CLIENT_ID_DOC = "The client ID of the application.";
    public static final String CLIENT_SECRET_CONFIG = "client.secret";
    public static final String CLIENT_SECRET_DOC = "The client secret for the authentication.";
    public static final String USERNAME_CONF = "username";
    public static final String USERNAME_DOC = "The username to authenticate with.";
    public static final String PASSWORD_CONF = "password";
    public static final String PASSWORD_DOC = "The password to authenticate with.";
    public static final String TENANT_ID_CONFIG = "tenant.id";
    public static final String TENANT_ID_DOC = "The tenant ID of the application.";
    public static final String VAULT_URL_CONFIG = "vault.url";
    public static final String VAULT_URL_DOC = "The vault url to connect to. For example `https://example.vault.azure.net/`";
    public static final String USE_JSON_CONFIG = "use.json";
    static final String USE_JSON_DOC = "If true, the secret will be parsed as a json object and the keys will be used as the config keys.";
    public final String prefix = this.getString("secret.prefix");
    public final CredentialLocation credentialLocation = (CredentialLocation)ConfigUtils.getEnum(CredentialLocation.class, (AbstractConfig)this, (String)"credential.type");
    public final String clientId = this.getString("client.id");
    public final String tenantId = this.getString("tenant.id");
    public final String vaultUrl = this.getString("vault.url");
    public final HttpClient httpClient = new OkHttpAsyncHttpClientBuilder().build();
    static final String GROUP_CLIENT_CERTIFICATE = "Client Certificate";
    static final String GROUP_CLIENT_SECRET = "Client Secret";
    static final String GROUP_CLIENT_USERNAME = "Username and Password";

    public KeyVaultConfigProviderConfig(Map<String, ?> settings) {
        super(KeyVaultConfigProviderConfig.config(), settings);
    }

    public static ConfigDef config() {
        return AbstractConfigProviderConfig.config().define(ConfigKeyBuilder.of((String)VAULT_URL_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(VAULT_URL_DOC).importance(ConfigDef.Importance.HIGH).build()).define(ConfigKeyBuilder.of((String)CREDENTIAL_TYPE_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(CREDENTIAL_TYPE_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)CredentialLocation.DefaultAzure.name()).validator(Validators.validEnum(CredentialLocation.class, (Enum[])new Enum[0])).build()).define(ConfigKeyBuilder.of((String)CLIENT_ID_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(CLIENT_ID_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)TENANT_ID_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(TENANT_ID_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)CERTIFICATE_PATH_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(CERTIFICATE_PATH_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_CERTIFICATE).defaultValue((Object)"").recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.ClientCertificate.name())).build()).define(ConfigKeyBuilder.of((String)CERTIFICATE_TYPE_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(CERTIFICATE_TYPE_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_CERTIFICATE).defaultValue((Object)ClientCertificateType.PEM.name()).recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.ClientCertificate.name())).validator(Validators.validEnum(ClientCertificateType.class, (Enum[])new Enum[0])).build()).define(ConfigKeyBuilder.of((String)CERTIFICATE_SEND_CHAIN_CONFIG, (ConfigDef.Type)ConfigDef.Type.BOOLEAN).documentation(CERTIFICATE_SEND_CHAIN_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_CERTIFICATE).defaultValue((Object)false).recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.ClientCertificate.name())).build()).define(ConfigKeyBuilder.of((String)CERTIFICATE_PFX_PASSWORD_CONFIG, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(CERTIFICATE_PFX_PASSWORD_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_CERTIFICATE).defaultValue((Object)"").recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.ClientCertificate.name())).build()).define(ConfigKeyBuilder.of((String)CLIENT_SECRET_CONFIG, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(CLIENT_SECRET_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_SECRET).defaultValue((Object)"").recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.ClientSecret.name())).build()).define(ConfigKeyBuilder.of((String)USERNAME_CONF, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(USERNAME_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_USERNAME).defaultValue((Object)"").recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.UsernamePassword.name())).build()).define(ConfigKeyBuilder.of((String)PASSWORD_CONF, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(PASSWORD_DOC).importance(ConfigDef.Importance.HIGH).group(GROUP_CLIENT_USERNAME).defaultValue((Object)"").recommender(Recommenders.visibleIf((String)CREDENTIAL_TYPE_CONFIG, (Object)CredentialLocation.UsernamePassword.name())).build()).define(ConfigKeyBuilder.of((String)PREFIX_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(PREFIX_DOC).importance(ConfigDef.Importance.LOW).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)USE_JSON_CONFIG, (ConfigDef.Type)ConfigDef.Type.BOOLEAN).documentation(USE_JSON_DOC).importance(ConfigDef.Importance.MEDIUM).defaultValue((Object)true).build());
    }

    String getRequiredString(String name) {
        String result = this.getString(name);
        if (result == null || result.isEmpty()) {
            throw new ConfigException(name, (Object)result, "Cannot be null or blank.");
        }
        return result;
    }

    public TokenCredential buildCredential() {
        DefaultAzureCredential result;
        switch (this.credentialLocation) {
            case DefaultAzure: {
                log.info("Building DefaultAzureCredential");
                result = ((DefaultAzureCredentialBuilder)new DefaultAzureCredentialBuilder().httpClient(this.httpClient)).build();
                break;
            }
            case ClientSecret: {
                Password clientSecretPassword = this.getPassword(CLIENT_SECRET_CONFIG);
                log.info("Building ClientSecretCredential");
                result = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(this.tenantId)).clientId(this.clientId)).clientSecret(clientSecretPassword.value()).build();
                break;
            }
            case ClientCertificate: {
                ClientCertificateType certificateType = (ClientCertificateType)ConfigUtils.getEnum(ClientCertificateType.class, (AbstractConfig)this, (String)CERTIFICATE_TYPE_CONFIG);
                String clientCertificatePath = this.getRequiredString(CERTIFICATE_PATH_CONFIG);
                log.info("Loading client certificate '{}'", (Object)clientCertificatePath);
                ClientCertificateCredentialBuilder clientCertificateCredentialBuilder = (ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().sendCertificateChain(this.getBoolean(CERTIFICATE_SEND_CHAIN_CONFIG).booleanValue()).tenantId(this.tenantId)).clientId(this.clientId);
                switch (certificateType) {
                    case PEM: {
                        log.info("Setting pemCertificate to {}", (Object)clientCertificatePath);
                        clientCertificateCredentialBuilder.pemCertificate(clientCertificatePath);
                        break;
                    }
                    case PFX: {
                        log.info("Setting pfxCertificate to {}", (Object)clientCertificatePath);
                        Password clientCertificatePassword = this.getPassword(CERTIFICATE_PFX_PASSWORD_CONFIG);
                        clientCertificateCredentialBuilder.pfxCertificate(clientCertificatePath, clientCertificatePassword.value());
                        break;
                    }
                    default: {
                        throw new ConfigException(CERTIFICATE_TYPE_CONFIG, (Object)certificateType, "Unsupported ClientCertificateType");
                    }
                }
                log.info("Building ClientCertificateCredential");
                result = clientCertificateCredentialBuilder.build();
                break;
            }
            case UsernamePassword: {
                String username = this.getRequiredString(USERNAME_CONF);
                Password password = this.getPassword(PASSWORD_CONF);
                result = ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)new UsernamePasswordCredentialBuilder().tenantId(this.tenantId)).clientId(this.clientId)).username(username).password(password.value()).build();
                break;
            }
            default: {
                throw new ConfigException(CREDENTIAL_TYPE_CONFIG, (Object)this.credentialLocation, "Unsupported ConfigLocation");
            }
        }
        log.info("Credential Type = {}", (Object)result.getClass().getName());
        return result;
    }

    public boolean isJsonSecret() {
        return this.getBoolean(USE_JSON_CONFIG);
    }

    public static enum CredentialLocation {
        DefaultAzure,
        ClientSecret,
        ClientCertificate,
        UsernamePassword;

    }

    public static enum ClientCertificateType {
        PEM,
        PFX;

    }
}

