/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.codegen;

import io.confluent.gateway.codegen.ApiCodeGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseApiCodeGenerator
extends ApiCodeGenerator<SimpleApiInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponseApiCodeGenerator.class);
    private static final String DEFAULT_TEMPLATE_RESOURCE = "simple-error-creators.ftl";
    private static final String DEFAULT_OUTPUT_FILE = "gateway-filters/src/main/java/io/confluent/gateway/filter/authswap/response/SimpleApiErrorCreators.java";

    public ErrorResponseApiCodeGenerator() {
        super(DEFAULT_TEMPLATE_RESOURCE, "SimpleApiErrorCreators");
    }

    public static void main(String[] args) {
        ErrorResponseApiCodeGenerator generator = new ErrorResponseApiCodeGenerator();
        generator.generateCode();
    }

    @Override
    protected List<String> prepareImports(List<SimpleApiInfo> apis) {
        Set imports = apis.stream().map(SimpleApiInfo::getResponseClassName).collect(Collectors.toSet());
        return imports.stream().sorted().collect(Collectors.toList());
    }

    @Override
    protected List<SimpleApiInfo> discoverApis() {
        ArrayList<SimpleApiInfo> simpleApis = new ArrayList<SimpleApiInfo>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            try {
                String responseName = this.apiKeyToResponseName(apiKey);
                String responseClassName = "org.apache.kafka.common.message." + responseName + "Data";
                Class<?> responseClass = Class.forName(responseClassName);
                boolean hasErrorCode = this.hasSetErrorCodeMethod(responseClass);
                if (hasErrorCode) {
                    boolean hasErrorMessage = this.hasSetErrorMessageMethod(responseClass);
                    SimpleApiInfo apiInfo = new SimpleApiInfo(apiKey, responseName, responseClassName, hasErrorCode, hasErrorMessage);
                    simpleApis.add(apiInfo);
                    LOGGER.debug("Found simple API: {} -> {} (errorCode: {}, errorMessage: {})", new Object[]{apiKey.name(), responseName, hasErrorCode, hasErrorMessage});
                    continue;
                }
                LOGGER.debug("Complex API (no top-level ErrorCode): {} -> {}", (Object)apiKey.name(), (Object)responseName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("Response class not found for API: {}", (Object)apiKey.name());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to analyze API: {}", (Object)apiKey.name(), (Object)e);
            }
        }
        LOGGER.info("Discovered {} simple APIs with error handling capabilities", (Object)simpleApis.size());
        return simpleApis;
    }

    @Override
    protected String getOutputFilePath() {
        if (this.outputClassName != null) {
            return "gateway-filters/src/main/java/io/confluent/gateway/filter/authswap/response/" + this.outputClassName + ".java";
        }
        return DEFAULT_OUTPUT_FILE;
    }

    private String apiKeyToResponseName(ApiKeys apiKey) {
        String apiKeyName = apiKey.name();
        String[] parts = apiKeyName.split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            result.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            result.append(part.substring(1).toLowerCase());
        }
        result.append("Response");
        return result.toString();
    }

    private boolean hasSetErrorCodeMethod(Class<?> responseClass) {
        try {
            responseClass.getMethod("setErrorCode", Short.TYPE);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean hasSetErrorMessageMethod(Class<?> responseClass) {
        try {
            responseClass.getMethod("setErrorMessage", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static class SimpleApiInfo {
        private final ApiKeys apiKey;
        private final String responseName;
        private final String responseClassName;
        private final boolean hasErrorCode;
        private final boolean hasErrorMessage;

        public SimpleApiInfo(ApiKeys apiKey, String responseName, String responseClassName, boolean hasErrorCode, boolean hasErrorMessage) {
            this.apiKey = apiKey;
            this.responseName = responseName;
            this.responseClassName = responseClassName;
            this.hasErrorCode = hasErrorCode;
            this.hasErrorMessage = hasErrorMessage;
        }

        public ApiKeys getApiKey() {
            return this.apiKey;
        }

        public String getResponseName() {
            return this.responseName;
        }

        public String getResponseClassName() {
            return this.responseClassName;
        }

        public boolean hasErrorCode() {
            return this.hasErrorCode;
        }

        public boolean hasErrorMessage() {
            return this.hasErrorMessage;
        }

        public String getMethodName() {
            String apiKeyName = this.apiKey.name();
            String[] parts = apiKeyName.split("_");
            StringBuilder result = new StringBuilder();
            for (String part : parts) {
                if (part.isEmpty()) continue;
                result.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() <= 1) continue;
                result.append(part.substring(1).toLowerCase());
            }
            return result.toString();
        }

        public String getSimpleClassName() {
            return this.responseClassName.substring(this.responseClassName.lastIndexOf(46) + 1);
        }
    }
}

