/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.annotations.DocumentationTip;
import io.confluent.csid.config.provider.common.AbstractConfigProviderConfig;
import io.confluent.csid.config.provider.common.ConfigDataHasher;
import io.confluent.csid.config.provider.common.ImmutableKey;
import io.confluent.csid.config.provider.common.ImmutableState;
import io.confluent.csid.config.provider.common.ImmutableSubscription;
import io.confluent.csid.config.provider.common.RetriableException;
import io.confluent.csid.config.provider.common.ScheduledExecutorServiceFactory;
import io.confluent.csid.config.provider.common.SecretRequest;
import io.confluent.csid.config.provider.common.SecretRequestParser;
import io.confluent.csid.config.provider.common.SecretRetriever;
import io.confluent.csid.config.provider.common.Subscription;
import io.confluent.csid.config.provider.common.UpdateHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.config.ConfigChangeCallback;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DocumentationTip(value="Config providers can be used with anything that supports the AbstractConfig base class that is shipped with Apache Kafka.")
public abstract class AbstractConfigProvider<CONFIG extends AbstractConfigProviderConfig>
implements ConfigProvider,
SecretRetriever {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigProvider.class);
    protected CONFIG config;
    protected ScheduledExecutorService executorService;
    ScheduledExecutorServiceFactory executorServiceFactory = config -> Executors.newScheduledThreadPool(config.threadCount);
    Map<String, Subscription> subscriptions;
    ConfigDataHasher configDataHasher;

    protected abstract CONFIG config(Map<String, ?> var1);

    protected abstract void configure();

    protected abstract Map<String, String> getSecret(SecretRequest var1) throws Exception;

    public abstract ConfigDef config();

    @Override
    public Map<String, String> retrieveSecret(SecretRequest secretRequest) {
        Callable<Map> callable = () -> {
            log.debug("retrieveSecret() - Calling getSecret('{}')", (Object)secretRequest);
            return this.getSecret(secretRequest);
        };
        Exception lastException = null;
        int attempt = 0;
        while (attempt < ((AbstractConfigProviderConfig)((Object)this.config)).retryCount) {
            Future<Map> future;
            log.trace("retrieveSecret() - attempt {} of {}", (Object)(++attempt), (Object)((AbstractConfigProviderConfig)((Object)this.config)).retryCount);
            if (1 == attempt) {
                log.debug("retrieveSecret() - Submitting first attempt for '{}' to run immediately.", (Object)secretRequest);
                future = this.executorService.submit(callable);
            } else {
                log.debug("retrieveSecret() - Submitting attempt {} for '{}' to run in {} seconds", new Object[]{attempt, secretRequest, ((AbstractConfigProviderConfig)((Object)this.config)).retryIntervalSeconds});
                future = this.executorService.schedule(callable, ((AbstractConfigProviderConfig)((Object)this.config)).retryIntervalSeconds, TimeUnit.SECONDS);
            }
            log.trace("retrieveSecret() - {}", (Object)this.executorService);
            try {
                return future.get(((AbstractConfigProviderConfig)((Object)this.config)).timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof RetriableException) {
                    log.warn("retrieveSecret() - RetriableException thrown. Retrying if attempt(s) are available.", ex.getCause());
                    lastException = ex;
                    continue;
                }
                log.error("retrieveSecret() - Exception thrown. Not retriable.", ex.getCause());
                throw this.createConfigException(secretRequest, ex.getCause());
            }
            catch (TimeoutException ex) {
                log.warn("retrieveSecret() - Timeout calling getSecret('{}'). Retrying if attempt(s) are available.", (Object)secretRequest);
                if (!future.isDone()) {
                    future.cancel(true);
                }
                lastException = ex;
            }
            catch (InterruptedException ex) {
                throw this.createConfigException(secretRequest, ex);
            }
        }
        throw this.createConfigException(secretRequest, lastException);
    }

    ConfigException createConfigException(SecretRequest storeName, Throwable causedBy) {
        ConfigException configException = new ConfigException(String.format("Exception thrown while retrieving '%s'. See log for previous exceptions", storeName));
        configException.initCause(causedBy);
        return configException;
    }

    public ConfigData get(String path) {
        return this.get(path, Collections.emptySet());
    }

    public ConfigData get(String path, Set<String> keys) {
        Map<String, String> result;
        log.debug("get(request = '{}' keys = '{}'", (Object)path, keys);
        SecretRequest request = SecretRequestParser.parse(path);
        Map<String, String> data = this.retrieveSecret(request);
        if (null == data || data.isEmpty()) {
            log.error("get() - Could not find request '{}}'", (Object)request);
            throw new ConfigException(String.format("Could not find secret for request '%s'", request));
        }
        this.configDataHasher.updateHash(request, data);
        if (null != keys && !keys.isEmpty()) {
            LinkedHashSet<String> misses = new LinkedHashSet<String>();
            LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
            for (String key : keys) {
                if (data.containsKey(key)) {
                    String value = data.get(key);
                    r.put(key, value);
                    continue;
                }
                misses.add(key);
            }
            if (!misses.isEmpty()) {
                throw new ConfigException(String.format("Key(s) '%s' are missing for request '%s'", String.join((CharSequence)"', '", misses), request));
            }
            result = r;
        } else {
            result = data;
        }
        return new ConfigData(result);
    }

    public void close() throws IOException {
        if (null != this.executorService) {
            log.debug("close() - Shutting down ScheduledExecutorService {}", (Object)this.executorService);
            this.executorService.shutdown();
            try {
                long wait = 3L;
                log.debug("close() - Waiting {} seconds for ScheduledExecutorService to terminate", (Object)3L);
                if (this.executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                    log.debug("close() - ScheduledExecutorService terminated");
                } else {
                    log.warn("close() - ScheduledExecutorService took longer than {} second(s) to terminate", (Object)3L);
                }
            }
            catch (InterruptedException e) {
                log.warn("awaitTermination of executor service interrupted.", (Throwable)e);
            }
        }
    }

    public void configure(Map<String, ?> settings) {
        this.config = this.config(settings);
        this.executorService = this.executorServiceFactory.create((AbstractConfigProviderConfig)((Object)this.config));
        this.subscriptions = new ConcurrentHashMap<String, Subscription>();
        this.configDataHasher = new ConfigDataHasher();
        this.configure();
    }

    public synchronized void subscribe(String path, Set<String> keys, ConfigChangeCallback callback) {
        if (!((AbstractConfigProviderConfig)((Object)this.config)).pollingEnabled) {
            throw new UnsupportedOperationException();
        }
        SecretRequest request = SecretRequestParser.parse(path);
        ImmutableKey key = ImmutableKey.builder().keys(keys).build();
        log.info("subscribe(request = '{}' keys='{}')", (Object)request, keys);
        Subscription subscription = this.subscriptions.compute(request.raw(), (s, existing) -> {
            ImmutableState.Builder stateBuilder;
            ImmutableSubscription.Builder builder = ImmutableSubscription.builder().path(request.raw());
            if (null != existing) {
                builder.future(existing.future());
                for (Map.Entry<Subscription.Key, Subscription.State> entry : existing.states().entrySet()) {
                    if (key.equals(entry.getKey())) continue;
                    builder.putStates(entry);
                }
                Subscription.State existingState = existing.states().get(key);
                if (null != existingState) {
                    stateBuilder = ImmutableState.builder().from(existingState);
                    if (existingState.callbacks().contains(callback)) {
                        log.warn("subscribe() - callback already exists.");
                    } else {
                        log.trace("subscribe() - adding callback to existing callback(s).");
                        stateBuilder = stateBuilder.addCallbacks(callback);
                    }
                } else {
                    stateBuilder = ImmutableState.builder().addCallbacks(callback);
                }
            } else {
                ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(new UpdateHandler(this.configDataHasher, this.subscriptions, request, this, this.executorService), 0L, ((AbstractConfigProviderConfig)((Object)((Object)this.config))).pollingIntervalSeconds, TimeUnit.SECONDS);
                builder.future(future);
                stateBuilder = ImmutableState.builder().addCallbacks(callback);
            }
            ImmutableState state = stateBuilder.build();
            builder.putStates(key, state);
            return builder.build();
        });
        log.trace("subscribe() - subscription = '{}'", (Object)subscription);
    }

    public synchronized void unsubscribe(String path, Set<String> keys, ConfigChangeCallback callback) {
        if (!((AbstractConfigProviderConfig)((Object)this.config)).pollingEnabled) {
            throw new UnsupportedOperationException();
        }
        SecretRequest request = SecretRequestParser.parse(path);
        ImmutableKey key = ImmutableKey.builder().keys(keys).build();
        log.info("unsubscribe(request = '{}' keys='{}')", (Object)request, keys);
        this.subscriptions.compute(request.raw(), (s, existing) -> {
            if (null == existing) {
                return null;
            }
            Subscription.State state = existing.states().get(key);
            if (null == state) {
                log.info("unsubscribe(request = '{}' keys='{}') - subscription for keys does not exist.", (Object)request, (Object)keys);
                return existing;
            }
            if (!state.callbacks().contains(callback)) {
                log.info("unsubscribe(request = '{}' keys='{}') - callback for keys does not exist.", (Object)request, (Object)keys);
                return existing;
            }
            ImmutableSubscription.Builder subscriptionBuilder = ImmutableSubscription.builder().future(existing.future()).path(existing.path());
            LinkedHashMap<Subscription.Key, Subscription.State> states = new LinkedHashMap<Subscription.Key, Subscription.State>(existing.states());
            if (state.callbacks().size() > 1) {
                ImmutableState.Builder stateBuilder = ImmutableState.builder();
                state.callbacks().stream().filter(c -> !Objects.equals(c, callback)).forEach(stateBuilder::addCallbacks);
                states.put(key, stateBuilder.build());
            } else {
                log.debug("unsubscribe(request = '{}' keys='{}') - removing all callbacks.", (Object)request, (Object)keys);
                states.remove(key);
            }
            if (states.isEmpty()) {
                log.debug("unsubscribe() - No subscriptions for request '{}'. Removing monitor.", (Object)request);
                existing.future().cancel(true);
                return null;
            }
            subscriptionBuilder.putAllStates(states);
            return subscriptionBuilder.build();
        });
    }

    public synchronized void unsubscribeAll() {
        if (!((AbstractConfigProviderConfig)((Object)this.config)).pollingEnabled) {
            throw new UnsupportedOperationException();
        }
        for (Map.Entry<String, Subscription> subscriptionEntry : this.subscriptions.entrySet()) {
            log.info("unsubscribeAll() - Canceling UpdateHandler for {}", (Object)subscriptionEntry.getKey());
            subscriptionEntry.getValue().future().cancel(true);
        }
        this.subscriptions.clear();
    }
}

