/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.ImmutableConfigDataState;
import io.confluent.csid.config.provider.common.SecretRequest;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.immutables.value.Value;

class ConfigDataHasher {
    Map<String, ConfigDataState> paths = new ConcurrentHashMap<String, ConfigDataState>();

    ConfigDataHasher() {
    }

    public Set<String> updateHash(SecretRequest path, Map<String, String> configData) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ConfigDataState newState = ConfigDataState.build(configData);
        this.paths.compute(path.raw(), (s, existing) -> {
            if (null != existing) {
                LinkedHashSet<String> keys = new LinkedHashSet<String>();
                keys.addAll(newState.hashes().keySet());
                keys.addAll(existing.hashes().keySet());
                for (String key : keys) {
                    Integer b;
                    Integer a = existing.hashes().get(key);
                    if (Objects.equals(a, b = newState.hashes().get(key))) continue;
                    result.add(key);
                }
            }
            return newState;
        });
        return result;
    }

    @Value.Immutable
    static interface ConfigDataState {
        public Map<String, Integer> hashes();

        public int configHashCode();

        public static ConfigDataState build(Map<String, String> data) {
            LinkedHashMap hashes = new LinkedHashMap();
            Object[] values = new Object[data.size()];
            AtomicInteger i = new AtomicInteger(0);
            data.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
                hashes.put((String)e.getKey(), Objects.hashCode(e.getValue()));
                values[i.getAndIncrement()] = e.getValue();
            });
            int configHashCode = Objects.hash(values);
            return ImmutableConfigDataState.builder().hashes(hashes).configHashCode(configHashCode).build();
        }
    }
}

