/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.ConfigDataHasher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ConfigDataHasher.ConfigDataState", generator="Immutables")
final class ImmutableConfigDataState
implements ConfigDataHasher.ConfigDataState {
    private final Map<String, Integer> hashes;
    private final int configHashCode;

    private ImmutableConfigDataState(Map<String, Integer> hashes, int configHashCode) {
        this.hashes = hashes;
        this.configHashCode = configHashCode;
    }

    @Override
    public Map<String, Integer> hashes() {
        return this.hashes;
    }

    @Override
    public int configHashCode() {
        return this.configHashCode;
    }

    public final ImmutableConfigDataState withHashes(Map<String, ? extends Integer> entries) {
        if (this.hashes == entries) {
            return this;
        }
        Map<String, Integer> newValue = ImmutableConfigDataState.createUnmodifiableMap(true, false, entries);
        return new ImmutableConfigDataState(newValue, this.configHashCode);
    }

    public final ImmutableConfigDataState withConfigHashCode(int value) {
        if (this.configHashCode == value) {
            return this;
        }
        return new ImmutableConfigDataState(this.hashes, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigDataState && this.equalTo(0, (ImmutableConfigDataState)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfigDataState another) {
        return this.hashes.equals(another.hashes) && this.configHashCode == another.configHashCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + this.configHashCode;
        return h;
    }

    public String toString() {
        return "ConfigDataState{hashes=" + this.hashes + ", configHashCode=" + this.configHashCode + "}";
    }

    public static ImmutableConfigDataState copyOf(ConfigDataHasher.ConfigDataState instance) {
        if (instance instanceof ImmutableConfigDataState) {
            return (ImmutableConfigDataState)instance;
        }
        return ImmutableConfigDataState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ConfigDataHasher.ConfigDataState", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONFIG_HASH_CODE = 1L;
        private long initBits = 1L;
        private Map<String, Integer> hashes = new LinkedHashMap<String, Integer>();
        private int configHashCode;

        private Builder() {
        }

        public final Builder from(ConfigDataHasher.ConfigDataState instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllHashes(instance.hashes());
            this.configHashCode(instance.configHashCode());
            return this;
        }

        public final Builder putHashes(String key, int value) {
            this.hashes.put(Objects.requireNonNull(key, "hashes key"), value);
            return this;
        }

        public final Builder putHashes(Map.Entry<String, ? extends Integer> entry) {
            Integer v;
            String k = entry.getKey();
            this.hashes.put(Objects.requireNonNull(k, "hashes key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "hashes value for key: " + k : null));
            return this;
        }

        public final Builder hashes(Map<String, ? extends Integer> entries) {
            this.hashes.clear();
            return this.putAllHashes(entries);
        }

        public final Builder putAllHashes(Map<String, ? extends Integer> entries) {
            for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
                Integer v;
                String k = e.getKey();
                this.hashes.put(Objects.requireNonNull(k, "hashes key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "hashes value for key: " + k : null));
            }
            return this;
        }

        public final Builder configHashCode(int configHashCode) {
            this.configHashCode = configHashCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableConfigDataState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigDataState(ImmutableConfigDataState.createUnmodifiableMap(false, false, this.hashes), this.configHashCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("configHashCode");
            }
            return "Cannot build ConfigDataState, some of required attributes are not set " + attributes;
        }
    }
}

