/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.Subscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import org.immutables.value.Generated;

@Generated(from="Subscription", generator="Immutables")
final class ImmutableSubscription
implements Subscription {
    private final ScheduledFuture<?> future;
    private final String path;
    private final Map<Subscription.Key, Subscription.State> states;

    private ImmutableSubscription(ScheduledFuture<?> future, String path, Map<Subscription.Key, Subscription.State> states) {
        this.future = future;
        this.path = path;
        this.states = states;
    }

    @Override
    public ScheduledFuture<?> future() {
        return this.future;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Map<Subscription.Key, Subscription.State> states() {
        return this.states;
    }

    public final ImmutableSubscription withFuture(ScheduledFuture<?> value) {
        if (this.future == value) {
            return this;
        }
        ScheduledFuture<?> newValue = Objects.requireNonNull(value, "future");
        return new ImmutableSubscription(newValue, this.path, this.states);
    }

    public final ImmutableSubscription withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableSubscription(this.future, newValue, this.states);
    }

    public final ImmutableSubscription withStates(Map<? extends Subscription.Key, ? extends Subscription.State> entries) {
        if (this.states == entries) {
            return this;
        }
        Map<Subscription.Key, Subscription.State> newValue = ImmutableSubscription.createUnmodifiableMap(true, false, entries);
        return new ImmutableSubscription(this.future, this.path, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubscription && this.equalTo(0, (ImmutableSubscription)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubscription another) {
        return this.future.equals(another.future) && this.path.equals(another.path) && this.states.equals(another.states);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.future.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.states.hashCode();
        return h;
    }

    public String toString() {
        return "Subscription{future=" + this.future + ", path=" + this.path + ", states=" + this.states + "}";
    }

    public static ImmutableSubscription copyOf(Subscription instance) {
        if (instance instanceof ImmutableSubscription) {
            return (ImmutableSubscription)instance;
        }
        return ImmutableSubscription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Subscription", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_FUTURE = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        private ScheduledFuture<?> future;
        private String path;
        private Map<Subscription.Key, Subscription.State> states = new LinkedHashMap<Subscription.Key, Subscription.State>();

        private Builder() {
        }

        public final Builder from(Subscription instance) {
            Objects.requireNonNull(instance, "instance");
            this.future(instance.future());
            this.path(instance.path());
            this.putAllStates(instance.states());
            return this;
        }

        public final Builder future(ScheduledFuture<?> future) {
            this.future = Objects.requireNonNull(future, "future");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putStates(Subscription.Key key, Subscription.State value) {
            this.states.put(Objects.requireNonNull(key, "states key"), Objects.requireNonNull(value, value == null ? "states value for key: " + key : null));
            return this;
        }

        public final Builder putStates(Map.Entry<? extends Subscription.Key, ? extends Subscription.State> entry) {
            Subscription.State v;
            Subscription.Key k = entry.getKey();
            this.states.put(Objects.requireNonNull(k, "states key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "states value for key: " + k : null));
            return this;
        }

        public final Builder states(Map<? extends Subscription.Key, ? extends Subscription.State> entries) {
            this.states.clear();
            return this.putAllStates(entries);
        }

        public final Builder putAllStates(Map<? extends Subscription.Key, ? extends Subscription.State> entries) {
            for (Map.Entry<? extends Subscription.Key, ? extends Subscription.State> e : entries.entrySet()) {
                Subscription.State v;
                Subscription.Key k = e.getKey();
                this.states.put(Objects.requireNonNull(k, "states key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "states value for key: " + k : null));
            }
            return this;
        }

        public ImmutableSubscription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubscription(this.future, this.path, ImmutableSubscription.createUnmodifiableMap(false, false, this.states));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("future");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build Subscription, some of required attributes are not set " + attributes;
        }
    }
}

