/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.ConfigDataHasher;
import io.confluent.csid.config.provider.common.SecretRequest;
import io.confluent.csid.config.provider.common.SecretRetriever;
import io.confluent.csid.config.provider.common.Subscription;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigChangeCallback;
import org.apache.kafka.common.config.ConfigData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UpdateHandler.class);
    final ConfigDataHasher configDataHasher;
    final Map<String, Subscription> subscriptions;
    final SecretRequest path;
    final SecretRetriever secretRetriever;
    final ScheduledExecutorService executorService;

    UpdateHandler(ConfigDataHasher configDataHasher, Map<String, Subscription> subscriptions, SecretRequest path, SecretRetriever secretRetriever, ScheduledExecutorService executorService) {
        this.configDataHasher = configDataHasher;
        this.subscriptions = subscriptions;
        this.path = path;
        this.secretRetriever = secretRetriever;
        this.executorService = executorService;
    }

    @Override
    public void run() {
        Subscription subscription = this.subscriptions.get(this.path.raw());
        if (null == subscription) {
            log.warn("run() - No subscriptions were found for '{}'", (Object)this.path);
            return;
        }
        log.debug("run() - Refreshing data for path '{}'", (Object)this.path);
        Map<String, String> data = this.secretRetriever.retrieveSecret(this.path);
        Set<String> updated = this.configDataHasher.updateHash(this.path, data);
        if (updated.isEmpty()) {
            log.debug("run() - no updates detected for '{}'", (Object)this.path);
            return;
        }
        log.info("run() - Updates detected for '{}':'{}'", (Object)this.path, updated);
        subscription.states().entrySet().stream().filter(e -> ((Subscription.Key)e.getKey()).keys().stream().anyMatch(updated::contains)).forEach(e -> {
            Map<String, String> updates = data.entrySet().stream().filter(i -> ((Subscription.Key)e.getKey()).keys().contains(i.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ConfigData configData = new ConfigData(updates);
            for (ConfigChangeCallback callback : ((Subscription.State)e.getValue()).callbacks()) {
                log.debug("run() - handing callback to executor for {}", (Object)callback);
                this.executorService.submit(() -> callback.onChange(this.path.raw(), configData));
            }
        });
    }
}

