/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common.config;

import io.confluent.csid.config.provider.annotations.Description;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.AbstractConfig;

public class ConfigUtils {
    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, AbstractConfig config, String key) {
        String textValue = config.getString(key);
        return Enum.valueOf(enumClass, textValue);
    }

    public static <T extends Enum<T>> String enumDescription(Class<T> enumClass, T ... excludes) {
        LinkedHashSet exclude = new LinkedHashSet(Arrays.asList(excludes));
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        Map descriptions = Stream.of(constants).filter(e -> !exclude.contains(e)).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toMap(Function.identity(), enumConstant -> {
            try {
                Field enumField = enumClass.getField(enumConstant.name());
                Description descriptionAttribute = enumField.getAnnotation(Description.class);
                String description = null != descriptionAttribute ? descriptionAttribute.value() : null;
                return description;
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException("Could not find field " + enumConstant.name(), ex);
            }
        }, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return ConfigUtils.enumDescription(descriptions);
    }

    public static <T extends Enum<T>> String enumDescription(Map<T, String> descriptions) {
        StringBuilder builder = new StringBuilder();
        descriptions.forEach((key, value) -> {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('`');
            builder.append(key.toString());
            builder.append("` - ");
            builder.append((String)value);
        });
        return builder.toString();
    }

    public static String enumValues(Class<?> enumClass) {
        StringJoiner joiner = new StringJoiner(", ");
        Stream.of(enumClass.getEnumConstants()).map(Object::toString).forEach(joiner::add);
        return joiner.toString();
    }
}

