/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class BannerLogger {
    private static final String DEFAULT_BANNER_LOCATION = "banner.txt";
    private final Logger targetLogger;
    private final Supplier<Stream<String>> bannerReader;
    private final Level targetLevel;

    public BannerLogger() {
        this(LoggerFactory.getLogger((String)"io.confluent.gateway.StartupShutdownLogger"), new BannerSupplier(DEFAULT_BANNER_LOCATION));
    }

    BannerLogger(Logger targetLogger, Supplier<Stream<String>> bannerReader) {
        this.targetLogger = targetLogger;
        this.bannerReader = bannerReader;
        this.targetLevel = Level.INFO;
    }

    public void log() {
        this.bannerReader.get().forEach(line -> this.targetLogger.atLevel(this.targetLevel).log(line));
    }

    static class BannerSupplier
    implements Supplier<Stream<String>> {
        private static final String LICENSE_TXT = "license.txt";
        private final Supplier<Stream<String>> linesSupplier;
        private final Set<String> licenseLines;

        BannerSupplier(String resourceName) {
            this(new FileLinesSupplier(resourceName), new FileLinesSupplier(LICENSE_TXT));
        }

        BannerSupplier(Supplier<Stream<String>> bannerLinesSupplier, Supplier<Stream<String>> licenceStream) {
            this.linesSupplier = bannerLinesSupplier;
            this.licenseLines = licenceStream.get().collect(Collectors.toSet());
        }

        @Override
        public Stream<String> get() {
            return this.linesSupplier.get().filter(Predicate.not(this.licenseLines::contains));
        }
    }

    static class FileLinesSupplier
    implements Supplier<Stream<String>> {
        private final String resourceName;

        FileLinesSupplier(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public Stream<String> get() {
            InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(this.resourceName);
            if (Objects.isNull(resourceStream)) {
                return Stream.empty();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceStream, Charset.defaultCharset()));
            return (Stream)bufferedReader.lines().onClose(() -> {
                try {
                    resourceStream.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }
}

