/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.route;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.common.record.Aliasable;
import io.confluent.gateway.common.util.HostPortValidator;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.route.BrokerIdentificationStrategy;
import io.confluent.gateway.config.route.StreamingDomainRef;
import io.confluent.gateway.config.route.security.RouteSecurity;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public record Route(@JsonProperty(required=true) @NonNull String name, @JsonProperty(required=true) @NonNull String endpoint, @JsonProperty(required=true) @NonNull StreamingDomainRef streamingDomain, @JsonProperty BrokerIdentificationStrategy brokerIdentificationStrategy, @JsonProperty RouteSecurity security, @JsonProperty boolean logNetwork, @JsonProperty boolean logFrames) implements Aliasable
{
    @Generated
    public Route(@JsonProperty(required=true) @NonNull String name, @JsonProperty(required=true) @NonNull String endpoint, @JsonProperty(required=true) @NonNull StreamingDomainRef streamingDomain, @JsonProperty BrokerIdentificationStrategy brokerIdentificationStrategy, @JsonProperty RouteSecurity security, @JsonProperty boolean logNetwork, @JsonProperty boolean logFrames) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (streamingDomain == null) {
            throw new NullPointerException("streamingDomain is marked non-null but is null");
        }
    }

    public static Route withDefaults(Route route) {
        if (StringUtils.isBlank((CharSequence)route.name())) {
            throw new GatewayConfigParseException("Route name cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)route.endpoint())) {
            throw new GatewayConfigParseException("Route endpoint cannot be blank");
        }
        if (route.name().contains(" ")) {
            throw new GatewayConfigParseException("Route name must not contain whitespace(s)");
        }
        try {
            HostPortValidator.validate((String)route.endpoint());
        }
        catch (IllegalArgumentException e) {
            throw new GatewayConfigParseException("Invalid endpoint format: " + route.endpoint() + ". Expected format is {host}:{port}", e);
        }
        return new Route(route.name(), route.endpoint(), route.streamingDomain(), route.brokerIdentificationStrategy() != null ? route.brokerIdentificationStrategy() : BrokerIdentificationStrategy.DEFAULT, RouteSecurity.withDefaults(route.security()), route.logNetwork(), route.logFrames());
    }

    @Override
    @NonNull
    public String toString() {
        return "Route[name=" + this.name + ", endpoint=" + this.endpoint + ", streamingDomain=" + String.valueOf(this.streamingDomain) + ", brokerIdentificationStrategy=" + String.valueOf(this.brokerIdentificationStrategy) + ", security=" + String.valueOf(this.security) + ", logNetwork=" + this.logNetwork + ", logFrames=" + this.logFrames + "]";
    }

    public String alias() {
        return "Route:" + this.name;
    }
}

