/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.route.security;

import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.route.security.AuthStrategy;
import io.confluent.gateway.config.ssl.Ssl;
import java.util.Map;
import lombok.NonNull;

public record RouteSecurity(AuthStrategy auth, Ssl ssl, Map<String, Object> swapConfig) {
    public static RouteSecurity withDefaults(RouteSecurity security) {
        AuthStrategy effectiveAuth;
        if (security == null) {
            return new RouteSecurity(AuthStrategy.DEFAULT, null, Map.of());
        }
        AuthStrategy authStrategy = effectiveAuth = security.auth() == null ? AuthStrategy.DEFAULT : security.auth();
        if (effectiveAuth.isSwap() && security.swapConfig() == null) {
            throw new GatewayConfigParseException("swapConfig must be provided when using a swap auth strategy");
        }
        return new RouteSecurity(effectiveAuth, security.ssl() != null ? Ssl.withDefaults(security.ssl()) : null, security.swapConfig());
    }

    @Override
    @NonNull
    public String toString() {
        return "RouteSecurity[auth=" + String.valueOf((Object)this.auth) + ", ssl=" + String.valueOf(this.ssl) + ", swapConfig=" + String.valueOf(this.swapConfig) + "]";
    }
}

