/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.secret;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.common.util.FileUtil;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.secret.PasswordProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record FilePasswordProvider(@JsonProperty(value="file", required=true) @NonNull String passwordFile) implements PasswordProvider
{
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePasswordProvider.class);

    public FilePasswordProvider(@JsonProperty(value="file", required=true) @NonNull String passwordFile) {
        Objects.requireNonNull(passwordFile, "Password file path cannot be null");
        if (StringUtils.isBlank((CharSequence)passwordFile)) {
            throw new GatewayConfigParseException("Password file path cannot be empty");
        }
        this.passwordFile = passwordFile = passwordFile.trim();
    }

    @Override
    public String getPassword() {
        String string;
        block12: {
            Path filePath = Paths.get(this.passwordFile, new String[0]);
            BufferedReader reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
            try {
                String password = reader.readLine();
                if (password == null) {
                    throw new GatewayConfigParseException("Password file is empty or contains no readable content: " + this.passwordFile);
                }
                string = password.stripTrailing();
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw new GatewayConfigParseException("Password file not found: " + this.passwordFile + ". Ensure the file exists and is readable by the Gateway process.", e);
                }
                catch (SecurityException e) {
                    throw new GatewayConfigParseException("Access denied reading password file: " + this.passwordFile + ". Check file permissions and process ownership.", e);
                }
                catch (IOException e) {
                    throw new GatewayConfigParseException("Error reading password file: " + this.passwordFile + ". Check file integrity and disk space.", e);
                }
                catch (Exception e) {
                    throw new GatewayConfigParseException("Unexpected error reading password file: " + this.passwordFile, e);
                }
            }
            reader.close();
        }
        return string;
    }

    @Override
    public void validate() {
        if (!FileUtil.isFileReadable((String)this.passwordFile)) {
            throw new GatewayConfigParseException("Password file does not exist or not readable: " + this.passwordFile);
        }
        PasswordProvider.super.validate();
    }

    @Override
    @NonNull
    public String toString() {
        return String.format("FilePasswordProvider[file=%s]", this.passwordFile);
    }
}

