/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config.streamingdomain;

import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.ssl.Ssl;
import lombok.NonNull;

public record BootstrapServer(@NonNull String id, @NonNull String endpoint, Ssl ssl) {
    public BootstrapServer(@NonNull String id, @NonNull String endpoint, Ssl ssl) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (id.isBlank()) {
            throw new GatewayConfigParseException("Bootstrap server ID cannot be null or empty");
        }
        if (endpoint.isBlank() || !endpoint.matches("^([A-Za-z_]+://)?[^:]+:\\d+$")) {
            throw new GatewayConfigParseException("Bootstrap server endpoint must be in the format PROTOCOL://host:port or host:port. e.g PLAINTEXT://localhost:9092 or localhost:9092. Invalid endpoint: " + endpoint);
        }
    }

    public static BootstrapServer withDefaults(BootstrapServer bs) {
        return new BootstrapServer(bs.id, bs.endpoint, bs.ssl() == null ? null : Ssl.withDefaults(bs.ssl()));
    }

    public String getHostPort() {
        String[] parts = this.endpoint.split("://", 2);
        return parts.length > 1 ? parts[1] : parts[0];
    }

    @Override
    @NonNull
    public String toString() {
        return "BootstrapServer[id=" + this.id + ", endpoint=" + this.endpoint + "]";
    }
}

