/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.builder;

import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.config.route.Route;
import io.confluent.gateway.config.route.StreamingDomainRef;
import io.confluent.gateway.config.streamingdomain.BootstrapServer;
import io.confluent.gateway.config.streamingdomain.KafkaCluster;
import io.confluent.gateway.config.streamingdomain.StreamingDomain;
import io.confluent.gateway.configadapter.builder.TlsConfigurationBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VirtualClusterConfigurationBuilder {
    private final TlsConfigurationBuilder tlsBuilder = new TlsConfigurationBuilder();
    private final Map<String, StreamingDomain> streamingDomainMap;
    private final Map<String, Map<String, BootstrapServer>> bootstrapServerMap;
    private final Map<String, List<String>> routeFiltersMap;

    public VirtualClusterConfigurationBuilder(Map<String, StreamingDomain> streamingDomainMap, Map<String, Map<String, BootstrapServer>> bootstrapServerMap, Map<String, List<String>> routeFiltersMap) {
        this.streamingDomainMap = streamingDomainMap;
        this.bootstrapServerMap = bootstrapServerMap;
        this.routeFiltersMap = routeFiltersMap;
    }

    public Map<String, Object> buildVirtualClusterConfiguration(Route route) {
        LinkedHashMap<String, Object> virtualCluster = new LinkedHashMap<String, Object>();
        virtualCluster.put("name", route.name());
        virtualCluster.put("targetCluster", this.buildTargetClusterConfiguration(route.streamingDomain()));
        virtualCluster.put("gateways", List.of(this.buildVirtualGatewayConfiguration(route)));
        if (this.routeFiltersMap.containsKey(route.name())) {
            virtualCluster.put("filters", this.routeFiltersMap.get(route.name()));
        }
        virtualCluster.put("logNetwork", route.logNetwork());
        virtualCluster.put("logFrames", route.logFrames());
        return virtualCluster;
    }

    private Map<String, Object> buildVirtualGatewayConfiguration(Route route) {
        LinkedHashMap<String, Object> virtualGateway = new LinkedHashMap<String, Object>();
        virtualGateway.put("name", route.name() + "-route");
        this.configureBrokerIdentificationStrategy(route, virtualGateway);
        this.configureTlsIfPresent(route, virtualGateway);
        return virtualGateway;
    }

    private void configureBrokerIdentificationStrategy(Route route, Map<String, Object> virtualGateway) {
        LinkedHashMap<String, Object> hostConfig = new LinkedHashMap<String, Object>();
        hostConfig.put("bootstrapAddress", route.endpoint());
        if (route.brokerIdentificationStrategy().isHostStrategy()) {
            hostConfig.put("advertisedBrokerAddressPattern", route.brokerIdentificationStrategy().pattern());
            virtualGateway.put("sniHostIdentifiesNode", hostConfig);
        } else {
            this.configurePortStrategy(route, hostConfig);
            virtualGateway.put("portIdentifiesNode", hostConfig);
        }
    }

    private void configurePortStrategy(Route route, Map<String, Object> hostConfig) {
        StreamingDomainRef streamingDomainRef = route.streamingDomain();
        KafkaCluster cluster = this.streamingDomainMap.get(streamingDomainRef.name()).kafkaCluster();
        if (route.brokerIdentificationStrategy().isPortStrategy() && cluster.nodeIdRanges() == null) {
            throw new GatewayConfigParseException("Kafka cluster " + cluster.name() + " does not have nodeIdRanges defined, but port strategy is used for route " + route.name());
        }
        ArrayList nodeRanges = new ArrayList();
        cluster.nodeIdRanges().forEach(range -> nodeRanges.add(Map.of("name", range.name(), "start", range.start(), "end", range.end())));
        hostConfig.put("nodeIdRanges", nodeRanges);
    }

    private void configureTlsIfPresent(Route route, Map<String, Object> virtualGateway) {
        if (route.security() != null && route.security().ssl() != null) {
            virtualGateway.put("tls", this.tlsBuilder.build(route.security().ssl()));
        }
    }

    private Map<String, Object> buildTargetClusterConfiguration(StreamingDomainRef streamingDomainRef) {
        LinkedHashMap<String, Object> targetCluster = new LinkedHashMap<String, Object>();
        BootstrapServer server = this.getBootstrapServer(streamingDomainRef);
        targetCluster.put("bootstrapServers", server.getHostPort());
        if (server.ssl() != null) {
            targetCluster.put("tls", this.tlsBuilder.build(server.ssl()));
        }
        return targetCluster;
    }

    private BootstrapServer getBootstrapServer(StreamingDomainRef streamingDomainRef) {
        Map<String, BootstrapServer> serverMap = this.bootstrapServerMap.get(streamingDomainRef.name());
        if (!serverMap.containsKey(streamingDomainRef.bootstrapServerId())) {
            throw new GatewayConfigParseException("Unable to resolve bootstrap server ID: " + streamingDomainRef.bootstrapServerId() + " in streaming domain: " + streamingDomainRef.name());
        }
        return serverMap.get(streamingDomainRef.bootstrapServerId());
    }
}

