/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.validation;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.configadapter.validation.ConfigurationValidator;
import io.confluent.gateway.configadapter.validation.ValidationError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SecretStoreValidator
implements ConfigurationValidator {
    @Override
    public List<ValidationError> validate(Gateway gateway) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashSet secretStoreNames = new HashSet();
        gateway.secretStores().forEach(secretStore -> {
            if (secretStoreNames.contains(secretStore.name())) {
                errors.add(new ValidationError("Duplicate secret store name: " + secretStore.name(), ""));
            } else {
                secretStoreNames.add(secretStore.name());
            }
        });
        return errors;
    }
}

