/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.validation;

import java.util.Objects;
import lombok.Generated;

public class ValidationError {
    private final String message;
    private final String context;
    private final ErrorSeverity severity;

    public ValidationError(String message) {
        this(message, null, ErrorSeverity.ERROR);
    }

    public ValidationError(String message, String context) {
        this(message, context, ErrorSeverity.ERROR);
    }

    public ValidationError(String message, String context, ErrorSeverity severity) {
        this.message = Objects.requireNonNull(message, "Error message cannot be null");
        this.context = context;
        this.severity = Objects.requireNonNull(severity, "Severity cannot be null");
    }

    public String getFormattedMessage() {
        if (this.context != null && !this.context.trim().isEmpty()) {
            return String.format("[%s] %s: %s", new Object[]{this.severity, this.context, this.message});
        }
        return String.format("[%s] %s", new Object[]{this.severity, this.message});
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationError that = (ValidationError)obj;
        return Objects.equals(this.message, that.message) && Objects.equals(this.context, that.context) && this.severity == that.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.context, this.severity});
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public ErrorSeverity getSeverity() {
        return this.severity;
    }

    public static enum ErrorSeverity {
        WARNING,
        ERROR,
        CRITICAL;

    }
}

