/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.config.SaslClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginCallbackHandler;

public record ClusterAuth(@JsonProperty(required=true) SaslClient sasl) {
    public static ClusterAuth withDefaults(ClusterAuth config) {
        return new ClusterAuth(SaslClient.withDefaults(config.sasl()));
    }

    public Map<String, Object> toSaslConfigMap(AuthenticateCallbackHandler callbackHandler) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("sasl.login.retry.backoff.ms", this.sasl.loginRetryBackoffMs());
        configMap.put("sasl.login.retry.backoff.max.ms", this.sasl.loginRetryBackoffMaxMs());
        configMap.put("sasl.login.refresh.window.factor", this.sasl.refreshWindowFactor());
        configMap.put("sasl.login.refresh.window.jitter", this.sasl.refreshWindowJitter());
        configMap.put("sasl.login.refresh.min.period.seconds", this.sasl.refreshMinPeriodSeconds());
        configMap.put("sasl.login.refresh.buffer.seconds", this.sasl.refreshBufferSeconds());
        try {
            Class<?> loginCallbackHandlerClass = Class.forName(this.sasl.callbackHandlerClass());
            configMap.put("sasl.login.callback.handler.class", loginCallbackHandlerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load login callback handler class: " + this.sasl.callbackHandlerClass(), e);
        }
        if (callbackHandler instanceof OAuthBearerLoginCallbackHandler) {
            configMap.putAll(this.sasl.oauth().toLoginSaslConfigMap());
        }
        return configMap;
    }
}

