/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.utils.ConfigUtil;
import java.lang.invoke.CallSite;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasContext;

public record JaasConfig(@JsonProperty(required=true) String file) {
    public JaasContext loadJaasContext(String mechanism) {
        try {
            String content = ConfigUtil.readFileContent(this.file);
            Map<CallSite, Password> jaasConfigMap = Map.of(mechanism.toLowerCase(Locale.ROOT) + ".sasl.jaas.config", new Password(content));
            return JaasContext.loadServerContext((ListenerName)ListenerName.normalised((String)"gateway"), (String)mechanism, jaasConfigMap);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read JAAS config file: " + this.file, e);
        }
    }

    public static JaasConfig withDefaults(JaasConfig config) {
        return new JaasConfig(config.file());
    }
}

