/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum SupportedSaslMechanism {
    OAUTHBEARER("OAUTHBEARER"),
    PLAIN("PLAIN");

    private final String mechanism;

    private SupportedSaslMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public static boolean isValidMechanism(String mechanism) {
        return Optional.ofNullable(mechanism).map(m -> Arrays.stream(SupportedSaslMechanism.values()).anyMatch(supported -> StringUtils.equals((CharSequence)supported.mechanism, (CharSequence)m))).orElse(false);
    }

    public static List<String> all() {
        return Arrays.stream(SupportedSaslMechanism.values()).map(SupportedSaslMechanism::getMechanism).toList();
    }

    public String getMechanism() {
        return this.mechanism;
    }
}

