/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.metrics;

import io.confluent.gateway.filter.authswap.metrics.AuthSwapMeter;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;

public class AuthMetricsRecorder {
    private final AuthSwapMeter metrics;

    public AuthMetricsRecorder(AuthSwapMeter metrics) {
        this.metrics = metrics;
    }

    public void incrementClientAuthSuccess(String route) {
        this.metrics.incrementClientAuth(AuthSwapMeter.OperationOutcome.SUCCESS, route);
    }

    public void incrementClientAuthFailure(String route) {
        this.metrics.incrementClientAuth(AuthSwapMeter.OperationOutcome.FAILURE, route);
    }

    public void incrementClusterAuthSuccess(String route) {
        this.metrics.incrementClusterAuth(AuthSwapMeter.OperationOutcome.SUCCESS, route);
    }

    public void incrementClusterAuthFailure(String route) {
        this.metrics.incrementClusterAuth(AuthSwapMeter.OperationOutcome.FAILURE, route);
    }

    public void incrementAnonymousClient(String route) {
        this.metrics.incrementAnonymousClient(route);
    }

    public <T> T executeAndRecordLatency(String metricName, Map<String, String> tags, Callable<T> operation) throws Exception {
        Timer.Sample sample = this.metrics.startTimer();
        T result = operation.call();
        this.metrics.stopTimer(sample, metricName, tags);
        return result;
    }

    public <T> CompletionStage<T> executeAsyncAndRecordLatency(String metricName, Map<String, String> tags, Callable<CompletionStage<T>> asyncOperation) {
        Timer.Sample sample = this.metrics.startTimer();
        try {
            return asyncOperation.call().thenApply(result -> {
                this.metrics.stopTimer(sample, metricName, tags);
                return result;
            }).exceptionally(throwable -> {
                throw new RuntimeException((Throwable)throwable);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

