/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore.file;

import io.confluent.csid.config.provider.k8s.K8sSecretConfigProvider;
import io.confluent.gateway.common.secretprovider.file.FileStoreConfig;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import io.confluent.gateway.filter.authswap.secretstore.SecretStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigData;

public class FileSecretStore
implements SecretStore<FileStoreConfig> {
    private final K8sSecretConfigProvider provider = this.createFileSecretConfigProvider();
    private FileStoreConfig config;

    private K8sSecretConfigProvider createFileSecretConfigProvider() {
        return new K8sSecretConfigProvider();
    }

    @Override
    public String getType() {
        return "File";
    }

    @Override
    public Credential exchangeCredential(Credential credential) {
        String username = credential.username();
        ConfigData configData = this.provider.get(this.config.getEffectivePath(), new HashSet<String>(Collections.singletonList(username)));
        return this.getCredentialFrom((String)configData.data().get(username), this.getSeparator(this.config));
    }

    @Override
    public void configure(FileStoreConfig config) {
        this.config = config;
        this.provider.configure(config.toMap());
    }

    @Override
    public String getSeparator(FileStoreConfig config) {
        return Optional.ofNullable(config.separator()).orElse(":");
    }
}

