/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore.vault;

import io.confluent.csid.config.provider.vault.VaultConfigProvider;
import io.confluent.gateway.common.secretprovider.vault.VaultSecretStoreConfig;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import io.confluent.gateway.filter.authswap.secretstore.SecretStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigData;

public class VaultSecretStore
implements SecretStore<VaultSecretStoreConfig> {
    private final VaultConfigProvider provider = this.createVaultConfigProvider();
    private VaultSecretStoreConfig config;

    private VaultConfigProvider createVaultConfigProvider() {
        return new VaultConfigProvider();
    }

    @Override
    public String getType() {
        return "Vault";
    }

    @Override
    public Credential exchangeCredential(Credential credential) {
        String username = credential.username();
        ConfigData configData = this.provider.get(this.config.path(), new HashSet<String>(Collections.singletonList(username)));
        return this.getCredentialFrom((String)configData.data().get(username), this.getSeparator(this.config));
    }

    @Override
    public void configure(VaultSecretStoreConfig config) {
        this.config = config;
        this.provider.configure(config.toMap());
    }

    @Override
    public String getSeparator(VaultSecretStoreConfig config) {
        return Optional.ofNullable(config.separator()).orElse(":");
    }
}

