/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.vault;

import io.confluent.csid.config.provider.vault.AuthHandler;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="AuthHandler.AuthResult", generator="Immutables")
final class ImmutableAuthResult
implements AuthHandler.AuthResult {
    private final String token;
    private final Long ttl;
    private final boolean tokenRenewable;
    private final boolean authRenewable;

    private ImmutableAuthResult(String token, Long ttl, boolean tokenRenewable, boolean authRenewable) {
        this.token = token;
        this.ttl = ttl;
        this.tokenRenewable = tokenRenewable;
        this.authRenewable = authRenewable;
    }

    @Override
    public Optional<String> token() {
        return Optional.ofNullable(this.token);
    }

    @Override
    public Optional<Long> ttl() {
        return Optional.ofNullable(this.ttl);
    }

    @Override
    public boolean tokenRenewable() {
        return this.tokenRenewable;
    }

    @Override
    public boolean authRenewable() {
        return this.authRenewable;
    }

    public final ImmutableAuthResult withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutableAuthResult(newValue, this.ttl, this.tokenRenewable, this.authRenewable);
    }

    public final ImmutableAuthResult withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableAuthResult(value, this.ttl, this.tokenRenewable, this.authRenewable);
    }

    public final ImmutableAuthResult withTtl(long value) {
        Long newValue = value;
        if (Objects.equals(this.ttl, newValue)) {
            return this;
        }
        return new ImmutableAuthResult(this.token, newValue, this.tokenRenewable, this.authRenewable);
    }

    public final ImmutableAuthResult withTtl(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.ttl, value)) {
            return this;
        }
        return new ImmutableAuthResult(this.token, value, this.tokenRenewable, this.authRenewable);
    }

    public final ImmutableAuthResult withTokenRenewable(boolean value) {
        if (this.tokenRenewable == value) {
            return this;
        }
        return new ImmutableAuthResult(this.token, this.ttl, value, this.authRenewable);
    }

    public final ImmutableAuthResult withAuthRenewable(boolean value) {
        if (this.authRenewable == value) {
            return this;
        }
        return new ImmutableAuthResult(this.token, this.ttl, this.tokenRenewable, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthResult && this.equalTo(0, (ImmutableAuthResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthResult another) {
        return Objects.equals(this.token, another.token) && Objects.equals(this.ttl, another.ttl) && this.tokenRenewable == another.tokenRenewable && this.authRenewable == another.authRenewable;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + Objects.hashCode(this.ttl);
        h += (h << 5) + Boolean.hashCode(this.tokenRenewable);
        h += (h << 5) + Boolean.hashCode(this.authRenewable);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AuthResult{");
        if (this.ttl != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("ttl=").append(this.ttl);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("tokenRenewable=").append(this.tokenRenewable);
        builder.append(", ");
        builder.append("authRenewable=").append(this.authRenewable);
        return builder.append("}").toString();
    }

    public static ImmutableAuthResult copyOf(AuthHandler.AuthResult instance) {
        if (instance instanceof ImmutableAuthResult) {
            return (ImmutableAuthResult)instance;
        }
        return ImmutableAuthResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthHandler.AuthResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TOKEN_RENEWABLE = 1L;
        private static final long INIT_BIT_AUTH_RENEWABLE = 2L;
        private long initBits = 3L;
        private String token;
        private Long ttl;
        private boolean tokenRenewable;
        private boolean authRenewable;

        private Builder() {
        }

        public final Builder from(AuthHandler.AuthResult instance) {
            Optional<Long> ttlOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> tokenOptional = instance.token();
            if (tokenOptional.isPresent()) {
                this.token(tokenOptional);
            }
            if ((ttlOptional = instance.ttl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            this.tokenRenewable(instance.tokenRenewable());
            this.authRenewable(instance.authRenewable());
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public final Builder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Builder ttl(Optional<Long> ttl) {
            this.ttl = ttl.orElse(null);
            return this;
        }

        public final Builder tokenRenewable(boolean tokenRenewable) {
            this.tokenRenewable = tokenRenewable;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder authRenewable(boolean authRenewable) {
            this.authRenewable = authRenewable;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAuthResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthResult(this.token, this.ttl, this.tokenRenewable, this.authRenewable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenRenewable");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("authRenewable");
            }
            return "Cannot build AuthResult, some of required attributes are not set " + attributes;
        }
    }
}

