/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.vault;

import io.confluent.csid.config.provider.common.AbstractConfigProviderConfig;
import io.confluent.csid.config.provider.common.config.ConfigKeyBuilder;
import io.confluent.csid.config.provider.common.config.ConfigUtils;
import io.confluent.csid.config.provider.common.config.Validators;
import io.confluent.csid.config.provider.common.util.Utils;
import io.confluent.csid.config.provider.vault.AuthMethod;
import io.github.jopenlibs.vault.EnvironmentLoader;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public class VaultConfigProviderConfig
extends AbstractConfigProviderConfig {
    public static final String ADDRESS_CONFIG = "vault.address";
    static final String ADDRESS_DOC = "Sets the address (URL) of the Vault server instance to which API calls should be sent. If no address is explicitly set, the object will look to the `VAULT_ADDR` If you do not supply it explicitly AND no environment variable value is found, then initialization may fail.";
    public static final String NAMESPACE_CONFIG = "vault.namespace";
    static final String NAMESPACE_DOC = "Sets a global namespace to the Vault server instance, if desired.";
    public static final String TOKEN_CONFIG = "vault.auth.token";
    static final String TOKEN_DOC = "Sets the token used to access Vault. If no token is explicitly set then the `VAULT_TOKEN` environment variable will be used. ";
    public static final String AUTH_METHOD_CONFIG = "vault.auth.method";
    static final String AUTH_METHOD_DOC = "The login method to use. " + ConfigUtils.enumDescription(AuthMethod.class, (Enum[])new AuthMethod[0]);
    public static final String SSL_VERIFY_ENABLED_CONFIG = "vault.ssl.verify.enabled";
    static final String SSL_VERIFY_ENABLED_DOC = "Flag to determine if the configProvider should verify the SSL Certificate of the Vault server. Outside of development this should never be enabled.";
    public static final String USERNAME_CONFIG = "vault.auth.username";
    static final String USERNAME_DOC = "The username to authenticate with.";
    public static final String PASSWORD_CONFIG = "vault.auth.password";
    static final String PASSWORD_DOC = "The password to authenticate with.";
    public static final String MOUNT_CONFIG = "vault.auth.mount";
    static final String MOUNT_DOC = "Location of the mount to use for authentication.";
    public static final String ROLE_CONFIG = "vault.auth.role";
    static final String ROLE_DOC = "The role to use for authentication.";
    public static final String SECRET_CONFIG = "vault.auth.secret";
    static final String SECRET_DOC = "The secret to use for authentication.";
    public static final String SECRETS_ENGINE_CONFIG = "vault.secrets.version";
    static final String SECRETS_ENGINE_DOC = "The secrets engine version (1 or 2) to use.";
    public static final String PREFIXPATH_CONFIG = "vault.prefixpath";
    static final String PREFIXPATH_DOC = "Path prefix for the secrets.";
    public static final String URL_LOGGING_ENABLED_CONFIG = "vault.url.logging.enabled";
    static final String URL_LOGGING_ENABLED_DOC = "Flag to copy java.util.logging messages for \"sun.net.www.protocol.http.HttpURLConnection\" to the providers logger. Warning this will log all of the traffic for ANY Vault client that is in the current JVM. This could also receive any log message for other code that uses java.net.UrlConnection.";
    public final boolean sslVerifyEnabled = this.getBoolean("vault.ssl.verify.enabled");
    public final AuthMethod authMethod = (AuthMethod)ConfigUtils.getEnum(AuthMethod.class, (AbstractConfig)this, (String)"vault.auth.method");
    public final String username = this.getString("vault.auth.username");
    public final String password = this.getPassword("vault.auth.password").value();
    public final String mount = this.getString("vault.auth.mount");
    public final String role = this.getString("vault.auth.role");
    public final String secret = this.getPassword("vault.auth.secret").value();
    public final Integer version = this.getInt("vault.secrets.version");
    public final String prefixPath = this.getString("vault.prefixpath");
    public final boolean urlLoggingEnabled = this.getBoolean("vault.url.logging.enabled");

    void checkNotDefault(String item) {
        ConfigDef config = VaultConfigProviderConfig.config();
        Object currentValue = this.get(item);
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)config.configKeys().get(item);
        if (Objects.equals(configKey.defaultValue, currentValue)) {
            throw new ConfigException(item, currentValue, "Value must be specified");
        }
    }

    public VaultConfigProviderConfig(Map<?, ?> originals) {
        super(VaultConfigProviderConfig.config(), originals);
        switch (this.authMethod) {
            case LDAP: 
            case UserPass: {
                this.checkNotDefault(USERNAME_CONFIG);
                this.checkNotDefault(PASSWORD_CONFIG);
                break;
            }
            case AppRole: {
                this.checkNotDefault(ROLE_CONFIG);
                this.checkNotDefault(SECRET_CONFIG);
                break;
            }
        }
        if (this.urlLoggingEnabled) {
            Logger.getLogger("sun.net.www.protocol.http.HttpURLConnection").setLevel(Level.ALL);
        }
    }

    public static ConfigDef config() {
        return AbstractConfigProviderConfig.config().define(ConfigKeyBuilder.of((String)ADDRESS_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(ADDRESS_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)AUTH_METHOD_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(AUTH_METHOD_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)AuthMethod.Token.name()).validator(Validators.validEnum(AuthMethod.class, (Enum[])new Enum[0])).build()).define(ConfigKeyBuilder.of((String)TOKEN_CONFIG, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(TOKEN_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)NAMESPACE_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(NAMESPACE_DOC).importance(ConfigDef.Importance.LOW).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)SSL_VERIFY_ENABLED_CONFIG, (ConfigDef.Type)ConfigDef.Type.BOOLEAN).documentation(SSL_VERIFY_ENABLED_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)true).build()).define(ConfigKeyBuilder.of((String)USERNAME_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(USERNAME_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)PASSWORD_CONFIG, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(PASSWORD_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)MOUNT_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(MOUNT_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)ROLE_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(ROLE_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)SECRET_CONFIG, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(SECRET_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)SECRETS_ENGINE_CONFIG, (ConfigDef.Type)ConfigDef.Type.INT).documentation(SECRETS_ENGINE_DOC).importance(ConfigDef.Importance.MEDIUM).defaultValue((Object)2).build()).define(ConfigKeyBuilder.of((String)URL_LOGGING_ENABLED_CONFIG, (ConfigDef.Type)ConfigDef.Type.BOOLEAN).documentation(URL_LOGGING_ENABLED_DOC).importance(ConfigDef.Importance.LOW).defaultValue((Object)false).build()).define(ConfigKeyBuilder.of((String)PREFIXPATH_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(PREFIXPATH_DOC).importance(ConfigDef.Importance.MEDIUM).defaultValue((Object)"").build());
    }

    public VaultConfig createConfig() {
        return this.createConfig(null);
    }

    VaultConfig createConfig(EnvironmentLoader environmentLoader) {
        String prefix;
        String namespace;
        Password token;
        SslConfig sslConfig = new SslConfig().verify(Boolean.valueOf(this.sslVerifyEnabled));
        VaultConfig result = new VaultConfig();
        if (null != environmentLoader) {
            result = result.environmentLoader(environmentLoader);
        }
        try {
            result = result.sslConfig(sslConfig.build());
        }
        catch (VaultException e) {
            ConfigException configException = new ConfigException("Exception thrown while configuring ssl");
            configException.initCause((Throwable)e);
            throw configException;
        }
        String address = this.getString(ADDRESS_CONFIG);
        if (!Utils.isNullOrEmpty((String)address)) {
            result = result.address(address);
        }
        if (!Utils.isNullOrEmpty((String)(token = this.getPassword(TOKEN_CONFIG)).value())) {
            result = result.token(token.value());
        }
        if (!Utils.isNullOrEmpty((String)(namespace = this.getString(NAMESPACE_CONFIG)))) {
            try {
                result = result.nameSpace(namespace);
            }
            catch (VaultException e) {
                ConfigException configException = new ConfigException(NAMESPACE_CONFIG, (Object)namespace, "Exception thrown setting namespace");
                configException.initCause((Throwable)e);
                throw configException;
            }
        }
        if (!Utils.isNullOrEmpty((String)(prefix = this.getString(PREFIXPATH_CONFIG)))) {
            result = result.prefixPath(prefix);
        }
        result.engineVersion(this.version);
        try {
            result = result.build();
        }
        catch (VaultException e) {
            ConfigException configException = new ConfigException("Exception thrown while configuring vault");
            configException.initCause((Throwable)e);
            throw configException;
        }
        return result;
    }
}

