/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.aws;

import io.confluent.csid.config.provider.common.AbstractConfigProviderConfig;
import io.confluent.csid.config.provider.common.config.ConfigKeyBuilder;
import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class SecretsManagerConfigProviderConfig
extends AbstractConfigProviderConfig {
    public static final String REGION_CONFIG = "aws.region";
    static final String REGION_DOC = "Sets the region to be used by the client. For example `us-west-2`";
    public static final String PREFIX_CONFIG = "secret.prefix";
    static final String PREFIX_DOC = "Sets a prefix that will be added to all paths. For example you can use `staging` or `production` and all of the calls to Secrets Manager will be prefixed with that path. This allows the same configuration settings to be used across multiple environments.";
    public static final String MIN_TTL_MS_CONFIG = "secret.ttl.ms";
    static final String MIN_TTL_MS_DOC = "The minimum amount of time that a secret should be used. After this TTL has expired Secrets Manager will be queried again in case there is an updated configuration.";
    public static final String AWS_ACCESS_KEY_ID_CONFIG = "aws.access.key";
    public static final String AWS_ACCESS_KEY_ID_DOC = "AWS access key ID to connect with. If this value is not set the `DefaultCredentialsProvider <https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/auth/credentials/DefaultCredentialsProvider.html>`_ will be used to attempt loading the credentials from several default locations.";
    public static final String AWS_SECRET_KEY_CONFIG = "aws.secret.key";
    public static final String AWS_SECRET_KEY_DOC = "AWS secret access key to connect with.";
    public static final String ENDPOINT_OVERRIDE = "endpoint.override";
    public static final String ENDPOINT_OVERRIDE_DOC = "The value to override the service address used by Secrets Manager Client.  See `Developer Guide <https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/using.html>` for more details.";
    public static final String USE_JSON_CONFIG = "use.json";
    static final String USE_JSON_DOC = "If true, the secret will be parsed as a json object and the keys will be used as the config keys.";
    public final String region;
    public final long minimumSecretTTL = this.getLong("secret.ttl.ms");
    public final AwsCredentials credentials;
    public final String prefix;
    public final String endpointOverride;

    public SecretsManagerConfigProviderConfig(Map<String, ?> settings) {
        super(SecretsManagerConfigProviderConfig.config(), settings);
        this.region = this.getString(REGION_CONFIG);
        String awsAccessKeyId = this.getString(AWS_ACCESS_KEY_ID_CONFIG);
        String awsSecretKey = this.getPassword(AWS_SECRET_KEY_CONFIG).value();
        this.credentials = null != awsAccessKeyId && !awsAccessKeyId.isEmpty() ? AwsBasicCredentials.create((String)awsAccessKeyId, (String)awsSecretKey) : DefaultCredentialsProvider.create().resolveCredentials();
        this.prefix = this.getString(PREFIX_CONFIG);
        this.endpointOverride = this.getString(ENDPOINT_OVERRIDE);
    }

    public static ConfigDef config() {
        return AbstractConfigProviderConfig.config().define(ConfigKeyBuilder.of((String)REGION_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(REGION_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)AWS_ACCESS_KEY_ID_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(AWS_ACCESS_KEY_ID_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)AWS_SECRET_KEY_CONFIG, (ConfigDef.Type)ConfigDef.Type.PASSWORD).documentation(AWS_SECRET_KEY_DOC).importance(ConfigDef.Importance.HIGH).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)PREFIX_CONFIG, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(PREFIX_DOC).importance(ConfigDef.Importance.LOW).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)MIN_TTL_MS_CONFIG, (ConfigDef.Type)ConfigDef.Type.LONG).documentation(MIN_TTL_MS_DOC).importance(ConfigDef.Importance.LOW).defaultValue((Object)Duration.ofMinutes(5L).toMillis()).validator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1000L)).build()).define(ConfigKeyBuilder.of((String)ENDPOINT_OVERRIDE, (ConfigDef.Type)ConfigDef.Type.STRING).documentation(ENDPOINT_OVERRIDE_DOC).importance(ConfigDef.Importance.LOW).defaultValue((Object)"").build()).define(ConfigKeyBuilder.of((String)USE_JSON_CONFIG, (ConfigDef.Type)ConfigDef.Type.BOOLEAN).documentation(USE_JSON_DOC).importance(ConfigDef.Importance.MEDIUM).defaultValue((Object)true).build());
    }

    public boolean isJsonSecret() {
        return this.getBoolean(USE_JSON_CONFIG);
    }
}

