/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.common.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface MappableRecord {
    default public Map<String, String> toMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        RecordComponent[] components = this.getClass().getRecordComponents();
        Arrays.stream(components).forEach(component -> {
            try {
                String fieldName = component.getName();
                Object value = component.getAccessor().invoke((Object)this, new Object[0]);
                Optional.ofNullable(value).map(Object::toString).flatMap(valueStr -> Optional.ofNullable(this.getConfigKey(fieldName)).map(configKey -> Map.entry(configKey, valueStr))).ifPresent(entry -> configMap.put((String)entry.getKey(), (String)entry.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to convert config field: " + component.getName(), e);
            }
        });
        return configMap;
    }

    @JsonIgnore
    public Map<String, String> getConfigKeyMap();

    @JsonIgnore
    default public String getConfigKey(String fieldName) {
        return this.getConfigKeyMap().get(fieldName);
    }
}

