/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    private FileUtil() {
    }

    public static boolean isFileReadable(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        Path file = Paths.get(filePath, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            return false;
        }
        return Files.isReadable(file);
    }

    public static void writeToFile(String filePath, String content) {
        if (StringUtils.isEmpty((CharSequence)filePath) || StringUtils.isEmpty((CharSequence)content)) {
            throw new IllegalArgumentException("File path and content must not be empty");
        }
        Path file = Paths.get(filePath, new String[0]);
        try {
            if (file.getParent() != null) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)content, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write to file: " + filePath, e);
        }
    }

    public static void writeYamlFile(String filePath, Map<String, Object> yaml, boolean sortKeys) {
        String yamlString;
        if (yaml == null) {
            throw new IllegalArgumentException("YAML cannot be null");
        }
        YAMLFactory yamlFactory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory).setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        try {
            yamlString = mapper.writeValueAsString(yaml);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write configuration to file: " + filePath, e);
        }
        Path path = Path.of(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create configuration file: " + filePath, e);
            }
        }
        FileUtil.writeToFile(path.toString(), yamlString);
    }
}

