/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.common.secretprovider.ProviderConfig;
import io.confluent.gateway.common.util.FileWatcher;
import io.confluent.gateway.filter.authswap.AuthSwapFilter;
import io.confluent.gateway.filter.authswap.config.AuthSwapFilterConfig;
import io.confluent.gateway.filter.authswap.config.ClientAuth;
import io.confluent.gateway.filter.authswap.config.ClusterAuth;
import io.confluent.gateway.filter.authswap.config.SupportedSaslMechanism;
import io.confluent.gateway.filter.authswap.secretstore.SecretStore;
import io.confluent.gateway.filter.authswap.secretstore.SecretStoreFactory;
import io.confluent.gateway.filter.authswap.utils.LoginUtil;
import io.kroxylicious.proxy.filter.FilterFactory;
import io.kroxylicious.proxy.filter.FilterFactoryContext;
import io.kroxylicious.proxy.plugin.Plugin;
import io.kroxylicious.proxy.plugin.PluginConfigurationException;
import io.kroxylicious.proxy.plugin.Plugins;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientProvider;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServerProvider;
import org.apache.kafka.common.security.plain.internals.PlainSaslServerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(configType=Config.class)
public class AuthSwap
implements FilterFactory<Config, AuthSwapFilterConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthSwap.class);
    private AuthenticateCallbackHandler validatorCallbackHandler;
    private FileWatcher jaasConfigFileWatcher;
    private volatile ClientAuth clientAuth;
    private static final Map<String, Runnable> SERVER_PROVIDER_INITIALIZERS = Map.of(SupportedSaslMechanism.OAUTHBEARER.getMechanism(), OAuthBearerSaslServerProvider::initialize, SupportedSaslMechanism.PLAIN.getMechanism(), PlainSaslServerProvider::initialize);
    private static final Map<String, Runnable> CLIENT_PROVIDER_INITIALIZERS = Map.of(SupportedSaslMechanism.OAUTHBEARER.getMechanism(), OAuthBearerSaslClientProvider::initialize, SupportedSaslMechanism.PLAIN.getMechanism(), () -> {});

    public AuthSwapFilterConfig initialize(FilterFactoryContext context, Config config) throws PluginConfigurationException {
        AuthenticateCallbackHandler loginCallbackHandler;
        SecretStore<?> secretStore;
        Plugins.requireConfig((Object)this, (Object)config);
        this.clientAuth = ClientAuth.withDefaults(config.clientAuth());
        ClusterAuth clusterAuth = ClusterAuth.withDefaults(config.clusterAuth());
        try {
            secretStore = SecretStoreFactory.createSecretStore(config.secretStore().provider());
        }
        catch (PluginConfigurationException e) {
            throw new PluginConfigurationException("Failed to create SecretStore", (Throwable)e);
        }
        CLIENT_PROVIDER_INITIALIZERS.get(clusterAuth.sasl().mechanism()).run();
        try {
            Class<?> loginCallbackHandlerClass = Class.forName(clusterAuth.sasl().callbackHandlerClass());
            loginCallbackHandler = (AuthenticateCallbackHandler)loginCallbackHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PluginConfigurationException("Failed to instantiate login callback handler", (Throwable)e);
        }
        if (this.clientAuth.sasl() != null) {
            SERVER_PROVIDER_INITIALIZERS.get(this.clientAuth.sasl().mechanism()).run();
            try {
                Class<?> validatorCallbackHandlerClass = Class.forName(this.clientAuth.sasl().callbackHandlerClass());
                this.validatorCallbackHandler = (AuthenticateCallbackHandler)validatorCallbackHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PluginConfigurationException("Failed to instantiate validator callback handler", (Throwable)e);
            }
            this.configureValidatorCallbackHandler(this.clientAuth);
            this.watchJaasConfigFile();
        }
        return new AuthSwapFilterConfig(new Config(this.clientAuth, clusterAuth, config.secretStore()), this.validatorCallbackHandler, loginCallbackHandler, secretStore);
    }

    private void configureValidatorCallbackHandler(ClientAuth clientAuth) {
        try {
            this.validatorCallbackHandler.configure(LoginUtil.createValidatorSaslConfigMap(clientAuth, this.validatorCallbackHandler), clientAuth.sasl().mechanism(), LoginUtil.getValidatorAppConfigurationEntry(clientAuth.sasl()));
            LOGGER.info("Configured validator callback handler for mechanism: {}", (Object)clientAuth.sasl().mechanism());
        }
        catch (Exception e) {
            LOGGER.error("Failed to configure validator callback handler", (Throwable)e);
            throw new PluginConfigurationException("Failed to configure validator callback handler", (Throwable)e);
        }
    }

    private void watchJaasConfigFile() {
        try {
            String jaasConfigFile = this.clientAuth.sasl().jaasConfig().file();
            Path jaasConfigPath = Paths.get(jaasConfigFile, new String[0]);
            this.jaasConfigFileWatcher = new FileWatcher(jaasConfigPath, this::handleJaasConfigChange);
            this.jaasConfigFileWatcher.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to setup JAAS config file watcher", (Throwable)e);
            LOGGER.warn("Continuing without JAAS config file watching capability");
        }
    }

    private void handleJaasConfigChange(String newContent) {
        try {
            LOGGER.info("JAAS config file changed, reconfiguring validator callback handler");
            this.configureValidatorCallbackHandler(this.clientAuth);
            LOGGER.info("Successfully reconfigured validator callback handler after JAAS config change");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reconfigure validator callback handler after JAAS config change. Will continue with old config", (Throwable)e);
        }
    }

    public AuthSwapFilter createFilter(FilterFactoryContext context, AuthSwapFilterConfig authSwapFilterConfig) {
        return new AuthSwapFilter(authSwapFilterConfig);
    }

    public void close(AuthSwapFilterConfig authSwapFilterConfig) {
        if (this.jaasConfigFileWatcher != null) {
            try {
                this.jaasConfigFileWatcher.close();
                LOGGER.info("Closed JAAS config file watcher");
            }
            catch (Exception e) {
                LOGGER.warn("Error closing JAAS config file watcher", (Throwable)e);
            }
        }
        if (this.validatorCallbackHandler != null) {
            this.validatorCallbackHandler.close();
        }
    }

    public record Config(@JsonProperty(required=true) ClientAuth clientAuth, @JsonProperty(required=true) ClusterAuth clusterAuth, @JsonProperty(required=true) SecretStoreConfig secretStore) {
    }

    public record SecretStoreConfig(@JsonProperty(required=true) String name, @JsonProperty(required=true) ProviderConfig provider) {
    }
}

