/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.client;

import io.confluent.gateway.filter.authswap.Session;
import io.confluent.gateway.filter.authswap.client.AbstractClientAuthProcessor;
import io.confluent.gateway.filter.authswap.client.AuthResult;
import io.confluent.gateway.filter.authswap.config.Ssl;
import io.confluent.gateway.filter.authswap.metrics.AuthMetricsRecorder;
import io.kroxylicious.proxy.filter.FilterContext;
import io.kroxylicious.proxy.plugin.PluginConfigurationException;
import io.kroxylicious.proxy.tls.ClientTlsContext;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtlsClientAuthProcessor
extends AbstractClientAuthProcessor {
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final Logger LOGGER = LoggerFactory.getLogger(MtlsClientAuthProcessor.class);
    private final SslPrincipalMapper sslPrincipalMapper;

    public MtlsClientAuthProcessor(Session session, AuthMetricsRecorder recorder, Ssl ssl) {
        super(session, recorder);
        this.sslPrincipalMapper = SslPrincipalMapper.fromRules((String)ssl.principalMappingRules());
    }

    @Override
    public CompletionStage<AuthResult> authenticate(ApiKeys apiKey, RequestHeaderData header, ApiMessage request, FilterContext context) {
        if (apiKey == ApiKeys.SASL_HANDSHAKE || apiKey == ApiKeys.SASL_AUTHENTICATE) {
            this.recorder.incrementClientAuthFailure(context.getVirtualClusterName());
            return CompletableFuture.completedStage(AuthResult.failure(new Throwable("SASL Handshake and Authenticate requests are not supported for mTLS authentication."), Errors.UNKNOWN_SERVER_ERROR.code()));
        }
        try {
            String clientId = this.getIncomingClientId(context);
            this.setIncomingClientId(clientId);
            if (ANONYMOUS.equals(clientId)) {
                this.recorder.incrementAnonymousClient(context.getVirtualClusterName());
            }
            this.recorder.incrementClientAuthSuccess(context.getVirtualClusterName());
        }
        catch (RuntimeException e) {
            this.recorder.incrementClientAuthFailure(context.getVirtualClusterName());
            return CompletableFuture.completedStage(AuthResult.failure(e, Errors.UNKNOWN_SERVER_ERROR.code()));
        }
        return CompletableFuture.completedStage(AuthResult.success(this.getIncomingClientId()));
    }

    @Override
    protected boolean shouldInterceptForAuthentication(ApiKeys apiKey, short apiVersion) {
        return apiKey == ApiKeys.SASL_HANDSHAKE || apiKey == ApiKeys.SASL_AUTHENTICATE || !this.isClusterConnectionEstablished();
    }

    @Override
    protected boolean shouldInterceptForReAuthentication(ApiKeys apiKey, short apiVersion) {
        return false;
    }

    private String getIncomingClientId(FilterContext context) {
        return ((ClientTlsContext)context.clientTlsContext().orElseThrow(() -> {
            LOGGER.error("mTLS to SASL authswap not supported for non tls client connection, for channel:{}", (Object)context.channelDescriptor());
            return new PluginConfigurationException("mTLS to SASL authswap not supported for non tls client connection");
        })).clientCertificate().map(cert -> {
            String subjectName = cert.getSubjectX500Principal().getName();
            if (subjectName == null) {
                return ANONYMOUS;
            }
            try {
                return this.sslPrincipalMapper.getName(subjectName);
            }
            catch (IOException e) {
                LOGGER.error("Failed to map name for subject: {}, based on SSL principal mapping rules, for channel: {}", (Object)subjectName, (Object)context.channelDescriptor());
                throw new RuntimeException("Failed to map name for " + subjectName + " based on SSL principal mapping rules", e);
            }
        }).orElse(ANONYMOUS);
    }
}

