/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.cluster.sasl;

import io.confluent.gateway.filter.authswap.config.AuthSwapFilterConfig;
import io.confluent.gateway.filter.authswap.config.ClusterAuth;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import io.confluent.gateway.filter.authswap.utils.LoginUtil;
import io.kroxylicious.proxy.filter.FilterContext;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerRefreshingLogin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaslClientHandler.class);
    private static final String GATEWAY_SASL_PROTOCOL_NAME = "gateway-kafka";
    private final AuthenticateCallbackHandler loginCallbackHandler;
    private final ClusterAuth clusterAuth;
    private final String clientAuthMechanism;
    private SaslClient saslClient;
    private LoginManager loginManager;
    private Subject subject;

    public SaslClientHandler(AuthSwapFilterConfig authSwapConfig) {
        this.loginCallbackHandler = authSwapConfig.loginCallbackHandler();
        this.clusterAuth = authSwapConfig.config().clusterAuth();
        this.clientAuthMechanism = this.clusterAuth.sasl().mechanism();
    }

    public void initializeSaslClient(Credential credential, FilterContext context) {
        try {
            this.initializeLoginManager(credential, context);
            this.saslClient = this.createSaslClient(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize sasl client for channel: {}, due to error: {}", (Object)context.channelDescriptor(), (Object)e);
            this.disposeLoginManager(context);
            throw new RuntimeException(e);
        }
    }

    public byte[] createSaslToken(byte[] saslToken, boolean isInitial) throws SaslException {
        if (saslToken == null) {
            throw new IllegalStateException("Error authenticating with the Kafka Broker: received a `null` saslToken.");
        }
        try {
            if (isInitial && !this.saslClient.hasInitialResponse()) {
                return saslToken;
            }
            return Subject.doAs(this.subject, () -> this.saslClient.evaluateChallenge(saslToken));
        }
        catch (PrivilegedActionException e) {
            String error = "An error: (" + String.valueOf(e) + ") occurred when evaluating SASL token received from the Kafka Broker.";
            error = error + " Kafka Client will go to AUTHENTICATION_FAILED state.";
            throw new SaslAuthenticationException(error, e.getCause());
        }
    }

    public boolean isInitialized() {
        return this.saslClient != null;
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    void initializeLoginManager(Credential credential, FilterContext context) throws Exception {
        String jaasConfig = LoginUtil.createJaasConfig(this.loginCallbackHandler, credential, this.clusterAuth);
        Map<String, Object> configs = LoginUtil.createLoginSaslConfigMap(jaasConfig, this.clusterAuth, this.loginCallbackHandler);
        JaasContext jaasContext = JaasContext.loadClientContext(Map.of("sasl.jaas.config", configs.get("sasl.jaas.config")));
        this.loginManager = LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)this.clientAuthMechanism, OAuthBearerRefreshingLogin.class, configs);
        this.subject = this.loginManager.subject();
        this.loginCallbackHandler.configure(configs, this.clientAuthMechanism, jaasContext.configurationEntries());
    }

    SaslClient createSaslClient(FilterContext context) {
        try {
            return Subject.doAs(this.subject, () -> {
                Object[] mechs = new String[]{this.clientAuthMechanism};
                LOGGER.trace("Creating SaslClient: service={};mechs={} for channel: {}", new Object[]{GATEWAY_SASL_PROTOCOL_NAME, Arrays.toString(mechs), context.channelDescriptor()});
                SaslClient saslClient = Sasl.createSaslClient((String[])mechs, null, GATEWAY_SASL_PROTOCOL_NAME, "localhost", null, (CallbackHandler)this.loginCallbackHandler);
                if (saslClient == null) {
                    throw new SaslAuthenticationException("Failed to create SaslClient with mechanism " + this.clientAuthMechanism);
                }
                return saslClient;
            });
        }
        catch (PrivilegedActionException e) {
            throw new SaslAuthenticationException("Failed to create SaslClient with mechanism " + this.clientAuthMechanism, e.getCause());
        }
    }

    public void dispose(FilterContext context) {
        if (this.saslClient != null) {
            try {
                LOGGER.trace("Disposing SASL client for channel: {}", (Object)context.channelDescriptor());
                this.saslClient.dispose();
            }
            catch (SaslException e) {
                LOGGER.error("Failed to dispose SASL client for channel: {} due to error: {}", (Object)context.channelDescriptor(), (Object)e);
            }
            finally {
                this.disposeLoginManager(context);
            }
            this.saslClient = null;
        }
    }

    private void disposeLoginManager(FilterContext context) {
        if (this.loginManager != null) {
            try {
                LOGGER.trace("Disposing login manager for channel: {}", (Object)context.channelDescriptor());
                this.loginCallbackHandler.close();
                this.loginManager.release();
            }
            catch (Exception e) {
                LOGGER.error("Failed to dispose login manager for channel: {}, due to error: {}", (Object)context.channelDescriptor(), (Object)e);
            }
        }
    }
}

