/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.config.SaslServer;
import io.confluent.gateway.filter.authswap.config.Ssl;
import io.confluent.gateway.filter.authswap.utils.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallbackHandler;

public record ClientAuth(@JsonProperty SaslServer sasl, @JsonProperty Ssl ssl, @JsonProperty Long connectionsMaxReAuthMs) {
    public ClientAuth {
        if (sasl == null && ssl == null || sasl != null && ssl != null) {
            throw new IllegalArgumentException("Exactly one of the configs for 'sasl' or 'ssl' must be provided for client authentication.");
        }
    }

    public static ClientAuth withDefaults(ClientAuth config) {
        return new ClientAuth(SaslServer.withDefaults(config.sasl()), config.ssl(), ConfigUtil.defaultIfNullOrNegative(config.connectionsMaxReAuthMs, 0L));
    }

    public Map<String, Object> toSaslConfigMap(AuthenticateCallbackHandler callbackHandler) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        if (callbackHandler instanceof OAuthBearerValidatorCallbackHandler) {
            configMap.putAll(this.sasl.oauth().toValidatorSaslConfigMap());
        }
        return configMap;
    }
}

