/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.metrics;

import io.confluent.gateway.filter.authswap.metrics.AuthSwapMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerAuthSwapMeter
implements AuthSwapMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerAuthSwapMeter.class);
    private final MeterRegistry registry;
    private final Counter.Builder clientAuthCounterBuilder;
    private final Counter.Builder clusterAuthCounterBuilder;
    private final Counter.Builder anonymousClientCounterBuilder;
    private final Map<String, Timer.Builder> timerBuilders;

    public MicrometerAuthSwapMeter() {
        this((MeterRegistry)Metrics.globalRegistry);
    }

    public MicrometerAuthSwapMeter(MeterRegistry registry) {
        this.registry = registry;
        this.clientAuthCounterBuilder = Counter.builder((String)"gateway_authswap_client_auth_total").description("Total client authentication");
        this.clusterAuthCounterBuilder = Counter.builder((String)"gateway_authswap_cluster_auth_total").description("Total cluster authentication");
        this.anonymousClientCounterBuilder = Counter.builder((String)"gateway_authswap_anonymous_client_total").description("Total anonymous client connections");
        this.timerBuilders = new HashMap<String, Timer.Builder>();
        this.timerBuilders.put("gateway_authswap_latency", Timer.builder((String)"gateway_authswap_latency").description("End-to-end AuthSwap authentication latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}));
        this.timerBuilders.put("gateway_authswap_secret_store_latency", Timer.builder((String)"gateway_authswap_secret_store_latency").description("Secret store credential exchange latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}));
    }

    @Override
    public void incrementClientAuth(AuthSwapMeter.OperationOutcome outcome, String route) {
        String resultValue = outcome == AuthSwapMeter.OperationOutcome.SUCCESS ? "success" : "failure";
        Counter counter = this.clientAuthCounterBuilder.tag("result", resultValue).tag("route", route).register(this.registry);
        counter.increment();
    }

    @Override
    public void incrementClusterAuth(AuthSwapMeter.OperationOutcome outcome, String route) {
        String resultValue = outcome == AuthSwapMeter.OperationOutcome.SUCCESS ? "success" : "failure";
        Counter counter = this.clusterAuthCounterBuilder.tag("result", resultValue).tag("route", route).register(this.registry);
        counter.increment();
    }

    @Override
    public void incrementAnonymousClient(String route) {
        Counter counter = this.anonymousClientCounterBuilder.tag("route", route).register(this.registry);
        counter.increment();
    }

    @Override
    public Timer.Sample startTimer() {
        return Timer.start((MeterRegistry)this.registry);
    }

    @Override
    public Duration stopTimer(Timer.Sample sample, String metricName, Map<String, String> tags) {
        if (sample != null) {
            Timer.Builder timerBuilder = this.timerBuilders.get(metricName);
            if (timerBuilder == null) {
                LOGGER.warn("Unknown metric name '{}' - no timer will be recorded. Known metrics: {}", (Object)metricName, this.timerBuilders.keySet());
                return Duration.ZERO;
            }
            Timer timer = timerBuilder.tags((String[])tags.entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).toArray(String[]::new)).register(this.registry);
            long durationNanos = sample.stop(timer);
            return Duration.ofNanos(durationNanos);
        }
        return Duration.ZERO;
    }
}

