/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.config.types.Password;

public record Credential(String username, Optional<Password> password) {
    public Credential {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Username cannot be null or blank");
        }
    }

    public static Credential withUsername(String username) {
        return new Credential(username, Optional.empty());
    }

    public static Credential withCredentials(String username, Password password) {
        return new Credential(username, Optional.ofNullable(password));
    }
}

