/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore;

import io.confluent.gateway.common.record.MappableRecord;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SecretStore<T extends MappableRecord> {
    public static final Logger LOGGER = LoggerFactory.getLogger(SecretStore.class);
    public static final String DEFAULT_SEPARATOR = ":";

    public String getType();

    public Credential exchangeCredential(Credential var1);

    public void configure(T var1);

    public String getSeparator(T var1);

    default public Credential getCredentialFrom(String data, String splitter) {
        String newUsername = null;
        String newPassword = null;
        if (splitter != null) {
            String[] splits = data.split(splitter, 2);
            if (splits.length == 2 && !StringUtils.isBlank((CharSequence)splits[0]) && !StringUtils.isBlank((CharSequence)splits[1])) {
                newUsername = splits[0];
                newPassword = splits[1];
            } else {
                LOGGER.error("Invalid split data: expected two non-blank parts. Separator: {}", (Object)splitter);
                throw new RuntimeException("Invalid split data: expected two non-blank parts. Separator: " + splitter);
            }
        }
        return Credential.withCredentials(newUsername, new Password(newPassword));
    }
}

