/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore;

import io.confluent.gateway.common.secretprovider.ProviderConfig;
import io.confluent.gateway.common.secretprovider.aws.AwsProviderConfig;
import io.confluent.gateway.common.secretprovider.azure.AzureProviderConfig;
import io.confluent.gateway.common.secretprovider.file.FileProviderConfig;
import io.confluent.gateway.common.secretprovider.vault.VaultProviderConfig;
import io.confluent.gateway.filter.authswap.secretstore.SecretStore;
import io.confluent.gateway.filter.authswap.secretstore.aws.AwsSecretStore;
import io.confluent.gateway.filter.authswap.secretstore.azure.AzureSecretStore;
import io.confluent.gateway.filter.authswap.secretstore.file.FileSecretStore;
import io.confluent.gateway.filter.authswap.secretstore.vault.VaultSecretStore;

public class SecretStoreFactory {
    public static SecretStore<?> createSecretStore(ProviderConfig providerConfig) {
        return switch (providerConfig.type()) {
            case "Vault" -> SecretStoreFactory.createVaultSecretStore(providerConfig);
            case "AWS" -> SecretStoreFactory.createAwsSecretStore(providerConfig);
            case "Azure" -> SecretStoreFactory.createAzureSecretStore(providerConfig);
            case "File" -> SecretStoreFactory.createFileSecretStore(providerConfig);
            default -> throw new IllegalArgumentException("Unknown provider type: " + providerConfig.type());
        };
    }

    private static SecretStore<?> createVaultSecretStore(ProviderConfig config) {
        if (config instanceof VaultProviderConfig) {
            VaultProviderConfig vaultConfig = (VaultProviderConfig)config;
            VaultSecretStore store = new VaultSecretStore();
            store.configure(vaultConfig.config());
            return store;
        }
        throw new IllegalArgumentException("Invalid Vault provider configuration");
    }

    private static SecretStore<?> createAwsSecretStore(ProviderConfig config) {
        if (config instanceof AwsProviderConfig) {
            AwsProviderConfig awsConfig = (AwsProviderConfig)config;
            AwsSecretStore store = new AwsSecretStore();
            store.configure(awsConfig.config());
            return store;
        }
        throw new IllegalArgumentException("Invalid Aws provider configuration");
    }

    private static SecretStore<?> createAzureSecretStore(ProviderConfig config) {
        if (config instanceof AzureProviderConfig) {
            AzureProviderConfig azureConfig = (AzureProviderConfig)config;
            AzureSecretStore store = new AzureSecretStore();
            store.configure(azureConfig.config());
            return store;
        }
        throw new IllegalArgumentException("Invalid Azure provider configuration");
    }

    private static SecretStore<?> createFileSecretStore(ProviderConfig config) {
        if (config instanceof FileProviderConfig) {
            FileProviderConfig fileConfig = (FileProviderConfig)config;
            FileSecretStore store = new FileSecretStore();
            store.configure(fileConfig.config());
            return store;
        }
        throw new IllegalArgumentException("Invalid File provider configuration");
    }
}

