/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore.azure;

import io.confluent.csid.config.provider.azure.KeyVaultConfigProvider;
import io.confluent.gateway.common.secretprovider.azure.AzureSecretStoreConfig;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import io.confluent.gateway.filter.authswap.secretstore.SecretStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigData;

public class AzureSecretStore
implements SecretStore<AzureSecretStoreConfig> {
    private final KeyVaultConfigProvider provider = this.createAzureConfigProvider();
    private AzureSecretStoreConfig config;

    private KeyVaultConfigProvider createAzureConfigProvider() {
        return new KeyVaultConfigProvider();
    }

    @Override
    public String getType() {
        return "Azure";
    }

    @Override
    public Credential exchangeCredential(Credential credential) {
        String username = credential.username();
        ConfigData configData = this.provider.get(username, new HashSet<String>(Collections.singletonList(username)));
        String password = (String)configData.data().get(username);
        return this.getCredentialFrom(password, this.getSeparator(this.config));
    }

    @Override
    public void configure(AzureSecretStoreConfig config) {
        this.config = config;
        this.provider.configure(config.toMap());
    }

    @Override
    public String getSeparator(AzureSecretStoreConfig config) {
        return Optional.ofNullable(config.separator()).orElse(":");
    }
}

