/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.vault;

import io.confluent.csid.config.provider.common.SecretRequest;
import io.confluent.csid.config.provider.vault.AuthHandler;
import io.confluent.csid.config.provider.vault.AuthHandlers;
import io.confluent.csid.config.provider.vault.VaultClient;
import io.confluent.csid.config.provider.vault.VaultConfigProviderConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VaultClientImpl
implements VaultClient {
    private static final Logger log = LoggerFactory.getLogger(VaultClientImpl.class);
    final AtomicReference<Vault> vaultStore = new AtomicReference();
    final AtomicReference<AuthHandler.AuthResult> authResultStore = new AtomicReference();

    public VaultClientImpl(VaultConfigProviderConfig config, ScheduledExecutorService executorService) {
        VaultConfig vaultConfig = config.createConfig();
        log.info("ctor() - creating initial vault client");
        Vault initialVault = Vault.create((VaultConfig)vaultConfig);
        this.vaultStore.set(initialVault);
        AuthHandler.AuthResult result = this.authenticateVault(config, vaultConfig);
        if (result.ttl().isPresent() && result.ttl().get() > 0L) {
            log.debug("ctor() - AuthResult does have a ttl - scheduling token renewal.");
            executorService.scheduleAtFixedRate(() -> this.authenticateVault(config, vaultConfig), 0L, result.ttl().get() - result.ttl().get() / 10L, TimeUnit.SECONDS);
        } else {
            log.debug("ctor() - AuthResult does not have a ttl so not scheduling token refresh.");
        }
    }

    private AuthHandler.AuthResult authenticateVault(VaultConfigProviderConfig config, VaultConfig vaultConfig) {
        AuthHandler.AuthResult result;
        log.debug("ctor() - authenticating vault");
        AuthHandler authHandler = AuthHandlers.get(config.authMethod);
        try {
            result = authHandler.execute(config, this.vaultStore.get());
        }
        catch (VaultException exception) {
            log.error("ctor() - exception thrown during initial authentication", (Throwable)exception);
            ConfigException configException = new ConfigException("Exception during initial authentication");
            configException.initCause((Throwable)exception);
            throw configException;
        }
        log.debug("ctor() - authResult = {}", (Object)result);
        result.token().ifPresent(arg_0 -> ((VaultConfig)vaultConfig).token(arg_0));
        return result;
    }

    @Override
    public LogicalResponse read(SecretRequest request) throws VaultException {
        log.debug("read() - request = '{}'", (Object)request);
        Vault vault = this.vaultStore.get();
        if (request.version().isPresent()) {
            Integer version = Integer.parseInt((String)request.version().get());
            return vault.logical().read(request.path(), Boolean.valueOf(false), version);
        }
        return vault.logical().read(request.path());
    }
}

