/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.bootstrap;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.NamedFilterDefinition;
import io.kroxylicious.proxy.config.PluginFactory;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.filter.FilterAndInvoker;
import io.kroxylicious.proxy.filter.FilterDispatchExecutor;
import io.kroxylicious.proxy.filter.FilterFactory;
import io.kroxylicious.proxy.filter.FilterFactoryContext;
import io.kroxylicious.proxy.plugin.PluginConfigurationException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FilterChainFactory
implements AutoCloseable {
    private final Map<String, Wrapper> initialized;

    public FilterChainFactory(final PluginFactoryRegistry pfr, @Nullable List<NamedFilterDefinition> filterDefinitions) {
        Class<FilterFactory> type = FilterFactory.class;
        PluginFactory<FilterFactory> pluginFactory = pfr.pluginFactory(type);
        if (filterDefinitions == null || filterDefinitions.isEmpty()) {
            this.initialized = Map.of();
        } else {
            FilterFactoryContext context = new FilterFactoryContext(){

                public FilterDispatchExecutor filterDispatchExecutor() {
                    throw new IllegalStateException("no Filter Dispatch executor available at filter factory initialization time");
                }

                public <P> P pluginInstance(Class<P> pluginClass, String instanceName) {
                    return pfr.pluginFactory(pluginClass).pluginInstance(instanceName);
                }
            };
            this.initialized = new LinkedHashMap<String, Wrapper>(filterDefinitions.size());
            try {
                for (NamedFilterDefinition fd : filterDefinitions) {
                    FilterFactory filterFactory = pluginFactory.pluginInstance(fd.type());
                    Class<?> configType = pluginFactory.configType(fd.type());
                    if (fd.config() == null || configType.isInstance(fd.config())) {
                        Wrapper uninitializedFilterFactory = new Wrapper(context, fd, (FilterFactory<? super Object, ? super Object>)filterFactory);
                        this.initialized.put(fd.name(), uninitializedFilterFactory);
                        continue;
                    }
                    throw new PluginConfigurationException("Filter " + fd.name() + " accepts config of type " + configType.getName() + " but provided with config of type " + fd.config().getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }
    }

    @Override
    public void close() {
        RuntimeException firstThrown = null;
        ArrayList<Wrapper> list = new ArrayList<Wrapper>(this.initialized.values());
        for (int i = list.size() - 1; i >= 0; --i) {
            Wrapper wrapper = list.get(i);
            try {
                wrapper.close();
                continue;
            }
            catch (RuntimeException e) {
                if (firstThrown == null) {
                    firstThrown = e;
                    continue;
                }
                firstThrown.addSuppressed(e);
            }
        }
        if (firstThrown != null) {
            throw firstThrown;
        }
    }

    public List<FilterAndInvoker> createFilters(FilterFactoryContext context, @Nullable List<NamedFilterDefinition> filterChain) {
        if (filterChain == null) {
            return List.of();
        }
        return filterChain.stream().flatMap(filterDefinition -> FilterAndInvoker.build(filterDefinition.name(), this.initialized.get(filterDefinition.name()).create(context)).stream()).toList();
    }

    private static final class Wrapper {
        private final FilterFactory<? super Object, ? super Object> filterFactory;
        private final NamedFilterDefinition filterDefinition;
        private final Object initResult;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private Wrapper(FilterFactoryContext context, NamedFilterDefinition filterDefinition, FilterFactory<? super Object, ? super Object> filterFactory) {
            this.filterFactory = filterFactory;
            this.filterDefinition = filterDefinition;
            Object config = filterDefinition.config();
            try {
                this.initResult = filterFactory.initialize(context, config);
            }
            catch (Exception e) {
                throw new PluginConfigurationException("Exception initializing filter factory " + filterDefinition.name() + " with config " + String.valueOf(config) + ": " + e.getMessage(), (Throwable)e);
            }
        }

        public Filter create(FilterFactoryContext context) {
            if (this.closed.get()) {
                throw new IllegalStateException("Filter factory " + this.filterDefinition.name() + " is closed");
            }
            try {
                return this.filterFactory.createFilter(context, this.initResult);
            }
            catch (Exception e) {
                throw new PluginConfigurationException("Exception instantiating filter " + this.filterDefinition.name() + " using factory " + String.valueOf(this.filterFactory), (Throwable)e);
            }
        }

        public void close() {
            if (!this.closed.getAndSet(true)) {
                this.filterFactory.close(this.initResult);
            }
        }

        public String toString() {
            return "Wrapper[filterFactory=" + String.valueOf(this.filterFactory) + ", filterDefinition=" + String.valueOf(this.filterDefinition) + "]";
        }
    }
}

