/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.IllegalConfigurationException;
import io.kroxylicious.proxy.config.MicrometerDefinition;
import io.kroxylicious.proxy.config.NamedFilterDefinition;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.config.VirtualCluster;
import io.kroxylicious.proxy.config.VirtualClusterGateway;
import io.kroxylicious.proxy.config.admin.ManagementConfiguration;
import io.kroxylicious.proxy.config.tls.Tls;
import io.kroxylicious.proxy.model.VirtualClusterModel;
import io.kroxylicious.proxy.service.NodeIdentificationStrategy;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"management", "filterDefinitions", "defaultFilters", "virtualClusters", "micrometer", "useIoUring", "development"})
public record Configuration(@JsonAlias(value={"adminHttp"}) @JsonDeserialize(using=AdminHttpDeprecationLoggingDeserializer.class) @Nullable ManagementConfiguration management, @Nullable List<NamedFilterDefinition> filterDefinitions, @Nullable List<String> defaultFilters, @JsonProperty(required=true) @JsonDeserialize(using=VirtualClusterContainerDeserializer.class) List<VirtualCluster> virtualClusters, @Nullable List<MicrometerDefinition> micrometer, boolean useIoUring, Optional<Map<String, Object>> development) {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);

    public Configuration(@JsonAlias(value={"adminHttp"}) @JsonDeserialize(using=AdminHttpDeprecationLoggingDeserializer.class) @Nullable ManagementConfiguration management, @Nullable List<NamedFilterDefinition> filterDefinitions, @Nullable List<String> defaultFilters, @JsonProperty(required=true) @JsonDeserialize(using=VirtualClusterContainerDeserializer.class) List<VirtualCluster> virtualClusters, @Nullable List<MicrometerDefinition> micrometer, boolean useIoUring, Optional<Map<String, Object>> development) {
        Objects.requireNonNull(development);
        if (virtualClusters == null || virtualClusters.isEmpty()) {
            throw new IllegalConfigurationException("At least one virtual cluster must be defined.");
        }
        this.validateNoDuplicatedClusterNames(virtualClusters);
        if (filterDefinitions != null) {
            Map<String, List<NamedFilterDefinition>> groupdByName = filterDefinitions.stream().collect(Collectors.groupingBy(NamedFilterDefinition::name));
            List<String> duplicatedNames = groupdByName.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).toList();
            if (!duplicatedNames.isEmpty()) {
                throw new IllegalConfigurationException("'filterDefinitions' contains multiple items with the same names: " + String.valueOf(duplicatedNames));
            }
            Set<String> filterDefsByName = Optional.ofNullable(filterDefinitions).orElse(List.of()).stream().map(NamedFilterDefinition::name).collect(Collectors.toSet());
            Configuration.checkNamedFiltersAreDefined(filterDefsByName, defaultFilters, "defaultFilters");
            for (VirtualCluster virtualCluster : virtualClusters) {
                Configuration.checkNamedFiltersAreDefined(filterDefsByName, virtualCluster.filters(), "virtualClusters." + virtualCluster.name() + ".filters");
            }
            this.checkAllNamedFilterAreUsed(filterDefinitions, virtualClusters, defaultFilters);
        }
        this.management = management;
        this.filterDefinitions = filterDefinitions;
        this.defaultFilters = defaultFilters;
        this.virtualClusters = virtualClusters;
        this.micrometer = micrometer;
        this.useIoUring = useIoUring;
        this.development = development;
    }

    private static void checkNamedFiltersAreDefined(Set<String> filterDefsByName, @Nullable List<String> filterNames, String componentName) {
        List<String> unknown = Optional.ofNullable(filterNames).orElse(List.of()).stream().filter(filterName -> !filterDefsByName.contains(filterName)).toList();
        if (!unknown.isEmpty()) {
            throw new IllegalConfigurationException("'" + componentName + "' references filters not defined in 'filterDefinitions': " + String.valueOf(unknown));
        }
    }

    private void validateNoDuplicatedClusterNames(List<VirtualCluster> clusters) {
        List<String> names = clusters.stream().map(VirtualCluster::name).map(name -> name.toLowerCase(Locale.ROOT)).toList();
        Set duplicates = names.stream().filter(i -> Collections.frequency(names, i) > 1).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new IllegalConfigurationException("Virtual cluster must be unique (case insensitive). The following virtual cluster names are duplicated: [%s]".formatted(String.join((CharSequence)", ", duplicates)));
        }
    }

    private void checkAllNamedFilterAreUsed(List<NamedFilterDefinition> filterDefinitions, List<VirtualCluster> clusters, List<String> defaultFilters) {
        HashSet defined = filterDefinitions.stream().map(NamedFilterDefinition::name).collect(Collectors.toCollection(HashSet::new));
        if (defaultFilters != null) {
            defaultFilters.forEach(defined::remove);
        }
        clusters.stream().map(VirtualCluster::filters).filter(Objects::nonNull).flatMap(Collection::stream).forEach(defined::remove);
        if (!defined.isEmpty()) {
            throw new IllegalConfigurationException("'filterDefinitions' defines filters which are not used in 'defaultFilters' or in any virtual cluster's 'filters': " + String.valueOf(defined));
        }
    }

    private static VirtualClusterModel toVirtualClusterModel(VirtualCluster virtualCluster, List<NamedFilterDefinition> filterDefinitions) {
        VirtualClusterModel virtualClusterModel = new VirtualClusterModel(virtualCluster.name(), virtualCluster.targetCluster(), virtualCluster.logNetwork(), virtualCluster.logFrames(), filterDefinitions);
        Configuration.addGateways(virtualCluster.gateways(), virtualClusterModel);
        virtualClusterModel.logVirtualClusterSummary();
        return virtualClusterModel;
    }

    private static void addGateways(List<VirtualClusterGateway> gateways, VirtualClusterModel virtualClusterModel) {
        gateways.forEach(gateway -> {
            NodeIdentificationStrategy nodeIdentificationStrategy = gateway.buildNodeIdentificationStrategy(virtualClusterModel.getClusterName());
            Optional<Tls> tls = gateway.tls();
            virtualClusterModel.addGateway(gateway.name(), nodeIdentificationStrategy, tls);
        });
    }

    public List<MicrometerDefinition> getMicrometer() {
        return this.micrometer() == null ? List.of() : this.micrometer();
    }

    public boolean isUseIoUring() {
        return this.useIoUring();
    }

    public List<VirtualClusterModel> virtualClusterModel(PluginFactoryRegistry pfr) {
        Map filterDefinitionsByName = Optional.ofNullable(this.filterDefinitions()).orElse(List.of()).stream().collect(Collectors.toMap(NamedFilterDefinition::name, Function.identity()));
        return this.virtualClusters.stream().map(virtualCluster -> {
            List<NamedFilterDefinition> filterDefinitions = this.namedFilterDefinitionsForCluster(filterDefinitionsByName, (VirtualCluster)virtualCluster);
            return Configuration.toVirtualClusterModel(virtualCluster, filterDefinitions);
        }).toList();
    }

    private List<NamedFilterDefinition> namedFilterDefinitionsForCluster(Map<String, NamedFilterDefinition> filterDefinitionsByName, VirtualCluster virtualCluster) {
        List<String> clusterFilters = virtualCluster.filters();
        List<NamedFilterDefinition> filterDefinitions = clusterFilters != null ? this.resolveFilterNames(filterDefinitionsByName, clusterFilters) : (this.defaultFilters != null ? this.resolveFilterNames(filterDefinitionsByName, this.defaultFilters) : List.of());
        return filterDefinitions;
    }

    private List<NamedFilterDefinition> resolveFilterNames(Map<String, NamedFilterDefinition> filterDefinitionsByName, List<String> filterNames) {
        return filterNames.stream().map(filterDefinitionsByName::get).toList();
    }

    static class AdminHttpDeprecationLoggingDeserializer
    extends StdDeserializer<ManagementConfiguration> {
        AdminHttpDeprecationLoggingDeserializer() {
            super(TypeFactory.defaultInstance().constructType(ManagementConfiguration.class));
        }

        public ManagementConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String currentName = jp.currentName();
            if ("adminHttp".equals(currentName)) {
                LOGGER.warn("The 'adminHttp' configuration property is deprecated and will be removed in a future release. Configurations should replace 'adminHttp' with 'management'.");
            }
            if (node.has("host")) {
                LOGGER.warn("The 'host' configuration property within the '{}' object  is deprecated and will be removed in a future release. Configurations should replace 'host' with 'bindAddress'.", (Object)currentName);
            }
            return (ManagementConfiguration)ctxt.readTreeAsValue(node, this.getValueType(ctxt));
        }
    }

    static class VirtualClusterContainerDeserializer
    extends StdDeserializer<List<VirtualCluster>> {
        VirtualClusterContainerDeserializer() {
            super(TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{VirtualCluster.class}));
        }

        public List<VirtualCluster> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node instanceof ObjectNode) {
                ObjectNode clusterMap = (ObjectNode)node;
                return this.convertDeprecatedMapToList(ctxt, clusterMap);
            }
            return (List)ctxt.readTreeAsValue(node, this.getValueType(ctxt));
        }

        private List<VirtualCluster> convertDeprecatedMapToList(DeserializationContext ctxt, ObjectNode clusterMap) throws IOException {
            LOGGER.warn("The 'virtualCluster' configuration property with a map as a value is deprecated and support be removed in a future release. Configurations should be updated to define 'virtualCluster' with a list objects, including a 'name' property.");
            ArrayNode clusterArrays = new ArrayNode(ctxt.getNodeFactory());
            Iterator clusterNames = clusterMap.fieldNames();
            clusterNames.forEachRemaining(clusterName -> {
                JsonNode value = clusterMap.get(clusterName);
                if (value instanceof ObjectNode) {
                    ObjectNode cluster = (ObjectNode)value;
                    JsonNode currentName = cluster.get("name");
                    if (currentName == null) {
                        cluster.set("name", (JsonNode)new TextNode(clusterName));
                    } else if (!currentName.asText().equals(clusterName)) {
                        throw new IllegalConfigurationException("Inconsistent virtual cluster configuration. Configuration property 'virtualClusters' refers to a map, but the key name '%s' is different to the value of the 'name' field '%s' in the value.".formatted(clusterName, currentName.asText()));
                    }
                    clusterArrays.add((JsonNode)cluster);
                }
            });
            return (List)ctxt.readTreeAsValue((JsonNode)clusterArrays, this._valueType);
        }
    }
}

