/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.stream.IntStream;

public record NamedRange(@JsonProperty(required=true) String name, @JsonProperty(required=true) @JsonInclude(value=JsonInclude.Include.ALWAYS) int start, @JsonProperty(required=true) @JsonInclude(value=JsonInclude.Include.ALWAYS) int end) {
    public NamedRange {
        Objects.requireNonNull(name);
        if (start > end) {
            throw new IllegalArgumentException("end of range: " + end + " is before start of range: " + start);
        }
    }

    public IntStream values() {
        return IntStream.rangeClosed(this.start, this.end);
    }

    boolean isEndBeforeStartOf(NamedRange range) {
        Objects.requireNonNull(range, "range to compare with is null");
        return this.end < range.start;
    }

    public boolean isDistinctFrom(NamedRange range) {
        Objects.requireNonNull(range, "range to compare with is null");
        return this.isEndBeforeStartOf(range) || range.isEndBeforeStartOf(this);
    }

    @Override
    public String toString() {
        return "NamedRange{name='" + this.name + "', start=" + this.start + ", end=" + this.end + "}";
    }

    public String toIntervalNotationString() {
        return "[" + this.start + "," + this.end + "]";
    }
}

