/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.BrokerAddressPatternUtils;
import io.kroxylicious.proxy.config.NodeIdentificationStrategyFactory;
import io.kroxylicious.proxy.service.HostPort;
import io.kroxylicious.proxy.service.NodeIdentificationStrategy;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SniHostIdentifiesNodeIdentificationStrategy
implements NodeIdentificationStrategyFactory {
    @JsonProperty(required=true)
    private final String bootstrapAddress;
    @JsonProperty(required=true)
    private final String advertisedBrokerAddressPattern;
    private static final Set<String> REQUIRED_TOKEN_SET = Set.of("$(nodeId)");
    private static final Set<String> ALLOWED_TOKEN_SET = Set.of("$(nodeId)", "$(virtualClusterName)");
    @JsonIgnore
    private final String parsedBootstrapAddressPattern;
    @JsonIgnore
    private final String parsedBrokerAddressPattern;
    @JsonIgnore
    private final Integer advertisedPort;
    @JsonIgnore
    private final Integer bootstrapPort;

    @JsonIgnore
    public String getBootstrapAddressPattern() {
        return this.parsedBootstrapAddressPattern;
    }

    @JsonIgnore
    public int getAdvertisedPort() {
        return this.advertisedPort;
    }

    @JsonIgnore
    public int getBootstrapPort() {
        return this.bootstrapPort;
    }

    @JsonCreator
    public SniHostIdentifiesNodeIdentificationStrategy(@JsonProperty(required=true, value="bootstrapAddress") String bootstrapAddress, @JsonProperty(required=true, value="advertisedBrokerAddressPattern") String advertisedBrokerAddressPattern) {
        if (bootstrapAddress == null) {
            throw new IllegalArgumentException("bootstrapAddress cannot be null");
        }
        if (advertisedBrokerAddressPattern == null) {
            throw new IllegalArgumentException("advertisedBrokerAddressPattern cannot be null");
        }
        this.bootstrapAddress = bootstrapAddress;
        this.advertisedBrokerAddressPattern = advertisedBrokerAddressPattern;
        BrokerAddressPatternUtils.PatternAndPort bootstrapPatternAndPort = BrokerAddressPatternUtils.parse(bootstrapAddress);
        Optional<Integer> maybeBootstrapPort = bootstrapPatternAndPort.port();
        if (maybeBootstrapPort.isEmpty()) {
            throw new IllegalArgumentException("bootstrapAddress " + bootstrapAddress + " does not contain a port");
        }
        this.bootstrapPort = maybeBootstrapPort.get();
        BrokerAddressPatternUtils.PatternAndPort patternAndPort = BrokerAddressPatternUtils.parse(advertisedBrokerAddressPattern);
        String brokerAddressPatternPart = patternAndPort.addressPattern();
        this.advertisedPort = patternAndPort.port().orElse(this.bootstrapPort);
        BrokerAddressPatternUtils.validatePortSpecifier(brokerAddressPatternPart, s -> {
            throw new IllegalArgumentException("advertisedBrokerAddressPattern address pattern cannot have port specifier.  Found port : " + s + " within " + brokerAddressPatternPart);
        });
        BrokerAddressPatternUtils.validateStringContainsOnlyExpectedTokens(brokerAddressPatternPart, ALLOWED_TOKEN_SET, tok -> {
            throw new IllegalArgumentException("advertisedBrokerAddressPattern contains an unexpected replacement token '" + tok + "'");
        });
        BrokerAddressPatternUtils.validateStringContainsRequiredTokens(brokerAddressPatternPart, REQUIRED_TOKEN_SET, tok -> {
            throw new IllegalArgumentException("advertisedBrokerAddressPattern must contain at least one nodeId replacement pattern '" + tok + "'");
        });
        this.parsedBootstrapAddressPattern = bootstrapPatternAndPort.addressPattern();
        this.parsedBrokerAddressPattern = brokerAddressPatternPart;
    }

    @JsonProperty(required=true)
    public String getBootstrapAddress() {
        return this.bootstrapAddress;
    }

    @JsonProperty(required=true)
    public String getAdvertisedBrokerAddressPattern() {
        return this.advertisedBrokerAddressPattern;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SniHostIdentifiesNodeIdentificationStrategy that = (SniHostIdentifiesNodeIdentificationStrategy)obj;
        return Objects.equals(this.bootstrapAddress, that.bootstrapAddress) && Objects.equals(this.advertisedBrokerAddressPattern, that.advertisedBrokerAddressPattern);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapAddress, this.advertisedBrokerAddressPattern);
    }

    public String toString() {
        return "SniHostIdentifiesNodeIdentificationStrategy[bootstrapAddress=" + this.bootstrapAddress + ", advertisedBrokerAddressPattern=" + this.advertisedBrokerAddressPattern + "]";
    }

    @Override
    public NodeIdentificationStrategy buildStrategy(String clusterName) {
        return new Strategy(clusterName);
    }

    private class Strategy
    implements NodeIdentificationStrategy {
        private final HostPort bootstrapAddress;
        private final String brokerAddressPattern;
        private final Pattern brokerAddressNodeIdCapturingRegex;
        private final int advertisedPort;

        private Strategy(String clusterName) {
            this.bootstrapAddress = new HostPort(BrokerAddressPatternUtils.replaceVirtualClusterName(SniHostIdentifiesNodeIdentificationStrategy.this.parsedBootstrapAddressPattern, clusterName), SniHostIdentifiesNodeIdentificationStrategy.this.getBootstrapPort());
            try {
                URI.create(this.bootstrapAddress.toString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Bootstrap address is not a valid URI: " + String.valueOf(this.bootstrapAddress), e);
            }
            this.brokerAddressPattern = BrokerAddressPatternUtils.replaceVirtualClusterName(SniHostIdentifiesNodeIdentificationStrategy.this.parsedBrokerAddressPattern, clusterName);
            this.brokerAddressNodeIdCapturingRegex = this.buildNodeIdCaptureRegex(clusterName);
            this.advertisedPort = SniHostIdentifiesNodeIdentificationStrategy.this.getAdvertisedPort();
            HostPort advertisedBrokerAddress = this.getAdvertisedBrokerAddress(1);
            try {
                URI.create(advertisedBrokerAddress.toString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Advertised broker address pattern did not produce a valid URI for test node 1: " + String.valueOf(advertisedBrokerAddress), e);
            }
            this.validateAddresses();
        }

        private void validateAddresses() {
            HostPort clusterBootstrapAddress = this.getClusterBootstrapAddress();
            URI.create(clusterBootstrapAddress.toString());
            HostPort advertisedBrokerAddress = this.getAdvertisedBrokerAddress(1);
            URI.create(advertisedBrokerAddress.toString());
        }

        private Pattern buildNodeIdCaptureRegex(String clusterName) {
            return Pattern.compile(BrokerAddressPatternUtils.createNodeIdCapturingRegexPattern(SniHostIdentifiesNodeIdentificationStrategy.this.parsedBrokerAddressPattern, clusterName), 2);
        }

        @Override
        public HostPort getClusterBootstrapAddress() {
            return this.bootstrapAddress;
        }

        @Override
        public HostPort getBrokerAddress(int nodeId) {
            if (nodeId < 0) {
                throw new IllegalArgumentException("nodeId cannot be less than zero");
            }
            return new HostPort(BrokerAddressPatternUtils.replaceLiteralNodeId(this.brokerAddressPattern, nodeId), this.bootstrapAddress.port());
        }

        @Override
        public HostPort getAdvertisedBrokerAddress(int nodeId) {
            HostPort brokerAddress = this.getBrokerAddress(nodeId);
            return new HostPort(brokerAddress.host(), this.advertisedPort);
        }

        @Override
        @Nullable
        public Integer getBrokerIdFromBrokerAddress(HostPort brokerAddress) {
            if (brokerAddress.port() != this.bootstrapAddress.port()) {
                return null;
            }
            Matcher matcher = this.brokerAddressNodeIdCapturingRegex.matcher(brokerAddress.host());
            if (matcher.matches()) {
                String nodeId = matcher.group(1);
                try {
                    return Integer.valueOf(nodeId);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("unexpected exception parsing : '%s'".formatted(nodeId), e);
                }
            }
            return null;
        }

        @Override
        public Set<Integer> getSharedPorts() {
            return Set.of(Integer.valueOf(this.bootstrapAddress.port()));
        }

        @Override
        public boolean requiresServerNameIndication() {
            return true;
        }
    }
}

