/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.filter;

import io.kroxylicious.proxy.filter.FilterContext;
import io.kroxylicious.proxy.filter.FilterInvoker;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.filter.ResponseFilterResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

record SafeInvoker(FilterInvoker invoker) implements FilterInvoker
{
    private static final Logger logger = LoggerFactory.getLogger(SafeInvoker.class);

    @Override
    public CompletionStage<RequestFilterResult> onRequest(ApiKeys apiKey, short apiVersion, RequestHeaderData header, ApiMessage body, FilterContext filterContext) {
        try {
            if (this.invoker.shouldHandleRequest(apiKey, apiVersion)) {
                CompletionStage<RequestFilterResult> stage = this.invoker.onRequest(apiKey, apiVersion, header, body, filterContext);
                if (stage == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("invoker onRequest returned null for apiKey {}, apiVersion {}, channel: {}, Filters should always return a CompletionStage", new Object[]{apiKey, apiVersion, filterContext.channelDescriptor()});
                    }
                    return CompletableFuture.failedFuture(new IllegalStateException("invoker onRequest returned null for apiKey " + String.valueOf(apiKey)));
                }
                return stage;
            }
            return filterContext.forwardRequest(header, body);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletionStage<ResponseFilterResult> onResponse(ApiKeys apiKey, short apiVersion, ResponseHeaderData header, ApiMessage body, FilterContext filterContext) {
        try {
            if (this.invoker.shouldHandleResponse(apiKey, apiVersion)) {
                CompletionStage<ResponseFilterResult> stage = this.invoker.onResponse(apiKey, apiVersion, header, body, filterContext);
                if (stage == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("invoker onResponse returned null for apiKey {}, apiVersion {}, channel: {}, Filters should always return a CompletionStage", new Object[]{apiKey, apiVersion, filterContext.channelDescriptor()});
                    }
                    return CompletableFuture.failedFuture(new IllegalStateException("invoker onResponse returned null for apiKey " + String.valueOf(apiKey)));
                }
                return stage;
            }
            return filterContext.forwardResponse(header, body);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public boolean shouldHandleRequest(ApiKeys apiKey, short apiVersion) {
        return this.invoker.shouldHandleRequest(apiKey, apiVersion);
    }

    @Override
    public boolean shouldHandleResponse(ApiKeys apiKey, short apiVersion) {
        return this.invoker.shouldHandleResponse(apiKey, apiVersion);
    }
}

