/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.authentication.ClientSaslContext;
import io.kroxylicious.proxy.filter.FilterAndInvoker;
import io.kroxylicious.proxy.filter.FilterContext;
import io.kroxylicious.proxy.filter.FilterResult;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.filter.RequestFilterResultBuilder;
import io.kroxylicious.proxy.filter.ResponseFilterResult;
import io.kroxylicious.proxy.filter.ResponseFilterResultBuilder;
import io.kroxylicious.proxy.frame.DecodedFrame;
import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.frame.DecodedResponseFrame;
import io.kroxylicious.proxy.frame.OpaqueFrame;
import io.kroxylicious.proxy.frame.OpaqueRequestFrame;
import io.kroxylicious.proxy.frame.OpaqueResponseFrame;
import io.kroxylicious.proxy.frame.RequestFrame;
import io.kroxylicious.proxy.internal.ClientSaslManager;
import io.kroxylicious.proxy.internal.ClientTlsContextImpl;
import io.kroxylicious.proxy.internal.InternalCompletionStage;
import io.kroxylicious.proxy.internal.InternalRequestFrame;
import io.kroxylicious.proxy.internal.InternalResponseFrame;
import io.kroxylicious.proxy.internal.PromiseFactory;
import io.kroxylicious.proxy.internal.filter.RequestFilterResultBuilderImpl;
import io.kroxylicious.proxy.internal.filter.ResponseFilterResultBuilderImpl;
import io.kroxylicious.proxy.internal.util.Assertions;
import io.kroxylicious.proxy.internal.util.ByteBufOutputStream;
import io.kroxylicious.proxy.model.VirtualClusterModel;
import io.kroxylicious.proxy.tls.ClientTlsContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterHandler.class);
    private final long timeoutMs;
    @Nullable
    private final String sniHostname;
    private final VirtualClusterModel virtualClusterModel;
    private final Channel inboundChannel;
    private final FilterAndInvoker filterAndInvoker;
    private final ClientSaslManager clientSaslManager;
    private CompletableFuture<Void> writeFuture = CompletableFuture.completedFuture(null);
    private CompletableFuture<Void> readFuture = CompletableFuture.completedFuture(null);
    @Nullable
    private ChannelHandlerContext ctx;
    @Nullable
    private PromiseFactory promiseFactory;

    public FilterHandler(FilterAndInvoker filterAndInvoker, long timeoutMs, @Nullable String sniHostname, VirtualClusterModel virtualClusterModel, Channel inboundChannel, ClientSaslManager clientSaslManager) {
        this.filterAndInvoker = Objects.requireNonNull(filterAndInvoker);
        this.timeoutMs = Assertions.requireStrictlyPositive(timeoutMs, "timeout");
        this.sniHostname = sniHostname;
        this.virtualClusterModel = virtualClusterModel;
        this.inboundChannel = inboundChannel;
        this.clientSaslManager = clientSaslManager;
    }

    public String toString() {
        return "FilterHandler{" + this.filterDescriptor() + "}";
    }

    String filterDescriptor() {
        return this.filterAndInvoker.filterName();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.promiseFactory = new PromiseFactory((ScheduledExecutorService)ctx.executor(), this.timeoutMs, TimeUnit.MILLISECONDS, LOGGER.getName());
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof InternalResponseFrame) {
            InternalResponseFrame decodedFrame = (InternalResponseFrame)msg;
            if (decodedFrame.isRecipient(this.filterAndInvoker.filter())) {
                this.completeInternalResponse(decodedFrame);
            } else {
                this.readDecodedResponse(decodedFrame);
            }
        } else if (msg instanceof DecodedResponseFrame) {
            DecodedResponseFrame decodedFrame = (DecodedResponseFrame)msg;
            this.readFuture = this.readFuture.isDone() ? this.readDecodedResponse(decodedFrame) : ((CompletableFuture)this.readFuture.thenCompose(ignored -> {
                if (ctx.channel().isOpen()) {
                    return this.readDecodedResponse(decodedFrame);
                }
                return CompletableFuture.completedFuture(null);
            })).exceptionally(throwable -> null);
        } else if (msg instanceof OpaqueResponseFrame) {
            OpaqueResponseFrame orf = (OpaqueResponseFrame)msg;
            this.readFuture = this.readFuture.whenComplete((a, b) -> {
                if (ctx.channel().isOpen()) {
                    ctx.fireChannelRead(msg);
                } else {
                    orf.releaseBuffer();
                }
            });
        } else {
            throw new IllegalStateException("Filter '" + this.filterAndInvoker.filterName() + "': Unexpected message reading from upstream: " + FilterHandler.msgDescriptor(msg));
        }
    }

    static String msgDescriptor(@Nullable Object obj) {
        if (obj == null) {
            return "\u00abnull\u00bb";
        }
        if (obj instanceof DecodedFrame) {
            DecodedFrame df = (DecodedFrame)obj;
            return df.getClass().getSimpleName() + "(" + String.valueOf(df.apiKey()) + "@" + df.apiVersion() + " corrId=" + df.correlationId() + ")";
        }
        if (obj instanceof OpaqueFrame) {
            OpaqueFrame of = (OpaqueFrame)obj;
            return of.toString();
        }
        return obj.getClass().getName();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof InternalRequestFrame) {
            InternalRequestFrame decodedFrame = (InternalRequestFrame)msg;
            this.writeDecodedRequest(decodedFrame, promise);
        } else if (msg instanceof DecodedRequestFrame) {
            DecodedRequestFrame decodedFrame = (DecodedRequestFrame)msg;
            this.writeFuture = this.writeFuture.isDone() ? this.writeDecodedRequest(decodedFrame, promise) : ((CompletableFuture)this.writeFuture.thenCompose(ignored -> {
                if (ctx.channel().isOpen()) {
                    return this.writeDecodedRequest(decodedFrame, promise);
                }
                return CompletableFuture.completedFuture(null);
            })).exceptionally(throwable -> null);
        } else if (msg instanceof OpaqueRequestFrame || msg == Unpooled.EMPTY_BUFFER) {
            this.writeFuture = this.writeFuture.whenComplete((unused, throwable) -> {
                if (ctx.channel().isOpen()) {
                    ctx.write(msg, promise);
                } else if (msg instanceof OpaqueRequestFrame) {
                    OpaqueRequestFrame orf = (OpaqueRequestFrame)msg;
                    orf.releaseBuffer();
                }
            });
        } else {
            throw new IllegalStateException("Filter '" + this.filterAndInvoker.filterName() + "': Unexpected message writing to upstream: " + FilterHandler.msgDescriptor(msg));
        }
    }

    private CompletableFuture<Void> readDecodedResponse(DecodedResponseFrame<?> decodedFrame) {
        boolean defer;
        InternalFilterContext filterContext = new InternalFilterContext(decodedFrame);
        CompletableFuture<ResponseFilterResult> future = this.dispatchDecodedResponseFrame(decodedFrame, filterContext);
        boolean bl = defer = !future.isDone();
        if (defer) {
            return ((CompletableFuture)this.configureResponseFilterChain(decodedFrame, this.handleDeferredStage(decodedFrame, future)).whenComplete(this::deferredResponseCompleted)).thenApply(responseFilterResult -> null);
        }
        return this.configureResponseFilterChain(decodedFrame, future).thenApply(responseFilterResult -> null);
    }

    private CompletableFuture<ResponseFilterResult> dispatchDecodedResponseFrame(DecodedResponseFrame<?> decodedFrame, InternalFilterContext filterContext) {
        CompletionStage<ResponseFilterResult> stage;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Dispatching upstream {} response to filter '{}': {}", new Object[]{this.channelDescriptor(), decodedFrame.apiKey(), this.filterDescriptor(), decodedFrame});
        }
        return (stage = this.filterAndInvoker.invoker().onResponse(decodedFrame.apiKey(), decodedFrame.apiVersion(), (ResponseHeaderData)decodedFrame.header(), (ApiMessage)decodedFrame.body(), filterContext)) instanceof InternalCompletionStage ? ((InternalCompletionStage)stage).getUnderlyingCompletableFuture() : stage.toCompletableFuture();
    }

    private CompletableFuture<ResponseFilterResult> configureResponseFilterChain(DecodedResponseFrame<?> decodedFrame, CompletableFuture<ResponseFilterResult> future) {
        return ((CompletableFuture)((CompletableFuture)future.thenApply(FilterHandler::validateFilterResultNonNull)).thenApply(fr -> this.handleResponseFilterResult(decodedFrame, (ResponseFilterResult)fr))).exceptionally(t -> (ResponseFilterResult)this.handleFilteringException((Throwable)t, (DecodedFrame<?, ?>)decodedFrame));
    }

    private CompletableFuture<Void> writeDecodedRequest(DecodedRequestFrame<?> decodedFrame, ChannelPromise promise) {
        boolean defer;
        InternalFilterContext filterContext = new InternalFilterContext(decodedFrame);
        CompletableFuture<RequestFilterResult> future = this.dispatchDecodedRequest(decodedFrame, filterContext);
        boolean bl = defer = !future.isDone();
        if (defer) {
            return ((CompletableFuture)this.configureRequestFilterChain(decodedFrame, promise, this.handleDeferredStage(decodedFrame, future)).whenComplete(this::deferredRequestCompleted)).thenApply(requestFilterResult -> null);
        }
        return this.configureRequestFilterChain(decodedFrame, promise, future).thenApply(requestFilterResult -> null);
    }

    private CompletableFuture<RequestFilterResult> dispatchDecodedRequest(DecodedRequestFrame<?> decodedFrame, InternalFilterContext filterContext) {
        CompletionStage<RequestFilterResult> stage;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Dispatching downstream {} request to filter '{}': {}", new Object[]{this.channelDescriptor(), decodedFrame.apiKey(), this.filterDescriptor(), decodedFrame});
        }
        return (stage = this.filterAndInvoker.invoker().onRequest(decodedFrame.apiKey(), decodedFrame.apiVersion(), (RequestHeaderData)decodedFrame.header(), (ApiMessage)decodedFrame.body(), filterContext)) instanceof InternalCompletionStage ? ((InternalCompletionStage)stage).getUnderlyingCompletableFuture() : stage.toCompletableFuture();
    }

    private CompletableFuture<RequestFilterResult> configureRequestFilterChain(DecodedRequestFrame<?> decodedFrame, ChannelPromise promise, CompletableFuture<RequestFilterResult> future) {
        return ((CompletableFuture)((CompletableFuture)future.thenApply(FilterHandler::validateFilterResultNonNull)).thenApply(fr -> this.handleRequestFilterResult(decodedFrame, promise, (RequestFilterResult)fr))).exceptionally(t -> (RequestFilterResult)this.handleFilteringException((Throwable)t, (DecodedFrame<?, ?>)decodedFrame));
    }

    private ResponseFilterResult handleResponseFilterResult(DecodedResponseFrame<?> decodedFrame, ResponseFilterResult responseFilterResult) {
        if (responseFilterResult.drop()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: Filter '{}' drops {} response", new Object[]{this.channelDescriptor(), this.filterDescriptor(), decodedFrame.apiKey()});
            }
            return responseFilterResult;
        }
        ApiMessage message = responseFilterResult.message();
        if (message != null) {
            ResponseHeaderData header = responseFilterResult.header() == null ? (ResponseHeaderData)decodedFrame.header() : (ResponseHeaderData)Objects.requireNonNull(responseFilterResult.header());
            this.forwardResponse(decodedFrame, header, message);
        }
        if (responseFilterResult.closeConnection()) {
            this.closeConnection();
        }
        return responseFilterResult;
    }

    private RequestFilterResult handleRequestFilterResult(DecodedRequestFrame<?> decodedFrame, ChannelPromise promise, RequestFilterResult requestFilterResult) {
        if (requestFilterResult.drop()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: Filter '{}' drops {} request", new Object[]{this.channelDescriptor(), this.filterDescriptor(), decodedFrame.apiKey()});
            }
            return requestFilterResult;
        }
        if (requestFilterResult.message() != null) {
            if (requestFilterResult.shortCircuitResponse()) {
                this.forwardShortCircuitResponse(decodedFrame, requestFilterResult);
            } else {
                this.forwardRequest(decodedFrame, requestFilterResult, promise);
            }
        }
        if (requestFilterResult.closeConnection()) {
            if (requestFilterResult.message() != null) {
                this.ctx.flush();
            }
            this.closeConnection();
        }
        return requestFilterResult;
    }

    @Nullable
    private <F extends FilterResult> F handleFilteringException(Throwable t, DecodedFrame<?, ?> decodedFrame) {
        if (LOGGER.isWarnEnabled()) {
            String direction = decodedFrame.header() instanceof RequestHeaderData ? "request" : "response";
            LOGGER.atWarn().setMessage("{}: Filter '{}' for {} {} ended exceptionally - closing connection. Cause message {}").addArgument((Object)this.channelDescriptor()).addArgument((Object)direction).addArgument((Object)this.filterDescriptor()).addArgument((Object)decodedFrame.apiKey()).addArgument((Object)t.getMessage()).setCause(LOGGER.isDebugEnabled() ? t : null).log();
        }
        this.closeConnection();
        return null;
    }

    private <F extends FilterResult> CompletableFuture<F> handleDeferredStage(DecodedFrame<?, ?> decodedFrame, CompletableFuture<F> future) {
        this.inboundChannel.config().setAutoRead(false);
        this.promiseFactory.wrapWithTimeLimit(future, () -> "Deferred work for filter '%s' did not complete processing within %s ms %s %s".formatted(this.filterDescriptor(), this.timeoutMs, decodedFrame instanceof DecodedRequestFrame ? "request" : "response", decodedFrame.apiKey()));
        return future.thenApplyAsync(filterResult -> filterResult, (Executor)this.ctx.executor());
    }

    private void deferredResponseCompleted(ResponseFilterResult ignored, Throwable throwable) {
        this.inboundChannel.config().setAutoRead(true);
        this.readFuture.whenComplete((u, t) -> this.inboundChannel.flush());
    }

    private void deferredRequestCompleted(RequestFilterResult ignored, Throwable throwable) {
        this.inboundChannel.config().setAutoRead(true);
        this.ctx.flush();
        this.writeFuture.whenComplete((u, t) -> this.ctx.flush());
        this.inboundChannel.flush();
    }

    private void forwardRequest(DecodedRequestFrame<?> decodedFrame, RequestFilterResult requestFilterResult, ChannelPromise promise) {
        Object header = requestFilterResult.header() == null ? decodedFrame.header() : requestFilterResult.header();
        ApiMessage message = requestFilterResult.message();
        if (decodedFrame.body() != message) {
            throw new IllegalStateException();
        }
        if (decodedFrame.header() != header) {
            throw new IllegalStateException();
        }
        String name = message.getClass().getName();
        if (!name.endsWith("RequestData")) {
            throw new AssertionError((Object)("Filter '" + this.filterDescriptor() + "': Attempt to use forwardRequest with a non-request: " + name));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Filter '{}' forwarding request: {}", new Object[]{this.channelDescriptor(), this.filterDescriptor(), decodedFrame});
        }
        this.ctx.write(decodedFrame, promise);
    }

    private void forwardResponse(DecodedFrame<?, ?> decodedFrame, ResponseHeaderData header, ApiMessage message) {
        String name = message.getClass().getName();
        if (!name.endsWith("ResponseData")) {
            throw new AssertionError((Object)("Filter '" + this.filterDescriptor() + "': Attempt to use forwardResponse with a non-response: " + name));
        }
        if (decodedFrame instanceof RequestFrame) {
            if (message.apiKey() != decodedFrame.apiKeyId()) {
                throw new AssertionError((Object)("Filter '" + this.filterDescriptor() + "': Attempt to respond with ApiMessage of type " + String.valueOf(ApiKeys.forId((int)message.apiKey())) + " but request is of type " + String.valueOf(decodedFrame.apiKey())));
            }
            DecodedResponseFrame<ApiMessage> responseFrame = new DecodedResponseFrame<ApiMessage>(decodedFrame.apiVersion(), decodedFrame.correlationId(), header, message);
            decodedFrame.transferBuffersTo(responseFrame);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: Filter '{}' forwarding response: {}", new Object[]{this.channelDescriptor(), this.filterDescriptor(), FilterHandler.msgDescriptor(decodedFrame)});
            }
            this.ctx.fireChannelRead(responseFrame);
            this.ctx.fireChannelReadComplete();
        } else {
            if (decodedFrame.body() != message) {
                throw new AssertionError();
            }
            if (decodedFrame.header() != header) {
                throw new AssertionError();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: Filter '{}' forwarding response: {}", new Object[]{this.channelDescriptor(), this.filterDescriptor(), FilterHandler.msgDescriptor(decodedFrame)});
            }
            this.ctx.fireChannelRead(decodedFrame);
        }
    }

    private void forwardShortCircuitResponse(DecodedRequestFrame<?> decodedFrame, RequestFilterResult requestFilterResult) {
        if (decodedFrame.hasResponse()) {
            ResponseHeaderData header = requestFilterResult.header() == null ? new ResponseHeaderData() : Objects.requireNonNull((ResponseHeaderData)requestFilterResult.header());
            header.setCorrelationId(decodedFrame.correlationId());
            this.forwardResponse(decodedFrame, header, Objects.requireNonNull(requestFilterResult.message()));
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Filter '{}' attempted to short-circuit respond to a message with apiKey {} that has no response in the Kafka Protocol, dropping response", new Object[]{this.channelDescriptor(), this.filterDescriptor(), decodedFrame.apiKey()});
        }
    }

    private void closeConnection() {
        this.ctx.close().addListener(future -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: Channel closed", (Object)this.channelDescriptor());
            }
        });
    }

    private String channelDescriptor() {
        return this.ctx.channel().toString();
    }

    private void completeInternalResponse(InternalResponseFrame<?> decodedFrame) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Completing {} response for request to filter '{}': {}", new Object[]{this.channelDescriptor(), decodedFrame.apiKey(), this.filterDescriptor(), decodedFrame});
        }
        CompletableFuture<?> p = decodedFrame.promise();
        p.complete(decodedFrame.body());
    }

    private static <F extends FilterResult> F validateFilterResultNonNull(F f) {
        return (F)Objects.requireNonNullElseGet(f, () -> {
            throw new IllegalStateException("Filter completion must not yield a null result");
        });
    }

    @Nullable
    static X509Certificate getPeerTlsCertificate(@Nullable SslHandler sslHandler) {
        if (sslHandler != null) {
            Certificate[] peerCertificates;
            SSLSession session = sslHandler.engine().getSession();
            try {
                peerCertificates = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = null;
            }
            if (peerCertificates != null && peerCertificates.length > 0) {
                return Objects.requireNonNull((X509Certificate)peerCertificates[0]);
            }
            return null;
        }
        return null;
    }

    @Nullable
    static X509Certificate localTlsCertificate(@Nullable SslHandler sslHandler) {
        if (sslHandler != null) {
            SSLSession session = sslHandler.engine().getSession();
            Certificate[] localCertificates = session.getLocalCertificates();
            if (localCertificates != null && localCertificates.length > 0) {
                return Objects.requireNonNull((X509Certificate)localCertificates[0]);
            }
            return null;
        }
        return null;
    }

    private class InternalFilterContext
    implements FilterContext {
        private final DecodedFrame<?, ?> decodedFrame;

        InternalFilterContext(DecodedFrame<?, ?> decodedFrame) {
            this.decodedFrame = decodedFrame;
        }

        public String channelDescriptor() {
            return FilterHandler.this.channelDescriptor();
        }

        public ByteBufferOutputStream createByteBufferOutputStream(int initialCapacity) {
            ByteBuf buffer = FilterHandler.this.ctx.alloc().ioBuffer(initialCapacity);
            this.decodedFrame.add(buffer);
            return new ByteBufOutputStream(buffer);
        }

        @Nullable
        public String sniHostname() {
            return FilterHandler.this.sniHostname;
        }

        public String getVirtualClusterName() {
            return FilterHandler.this.virtualClusterModel.getClusterName();
        }

        public Optional<ClientTlsContext> clientTlsContext() {
            return Optional.ofNullable((SslHandler)FilterHandler.this.inboundChannel.pipeline().get(SslHandler.class)).map(clientFacingSslHandler -> new ClientTlsContextImpl(Objects.requireNonNull(FilterHandler.localTlsCertificate(clientFacingSslHandler)), FilterHandler.getPeerTlsCertificate(clientFacingSslHandler)));
        }

        public void clientSaslAuthenticationSuccess(String mechanism, String authorizedId) {
            LOGGER.atInfo().setMessage("{}: Filter '{}' announces client has passed SASL authentication using mechanism '{}' and authorizationId '{}'.").addArgument((Object)this.channelDescriptor()).addArgument((Object)FilterHandler.this.filterDescriptor()).addArgument((Object)mechanism).addArgument((Object)authorizedId).log();
            FilterHandler.this.clientSaslManager.clientSaslAuthenticationSuccess(mechanism, authorizedId);
        }

        public void clientSaslAuthenticationFailure(@Nullable String mechanism, @Nullable String authorizedId, Exception exception) {
            LOGGER.atInfo().setMessage("{}: Filter '{}' announces client has failed SASL authentication using mechanism '{}' and authorizationId '{}'. Cause message {}." + (LOGGER.isDebugEnabled() ? "" : " Increase log level to DEBUG for stacktrace.")).setCause((Throwable)(LOGGER.isDebugEnabled() ? exception : null)).addArgument((Object)this.channelDescriptor()).addArgument((Object)FilterHandler.this.filterDescriptor()).addArgument((Object)mechanism).addArgument((Object)authorizedId).addArgument((Object)exception.toString()).log();
            FilterHandler.this.clientSaslManager.clientSaslAuthenticationFailure();
        }

        public Optional<ClientSaslContext> clientSaslContext() {
            return FilterHandler.this.clientSaslManager.clientSaslContext();
        }

        public RequestFilterResultBuilder requestFilterResultBuilder() {
            return new RequestFilterResultBuilderImpl();
        }

        public ResponseFilterResultBuilder responseFilterResultBuilder() {
            return new ResponseFilterResultBuilderImpl();
        }

        public CompletionStage<RequestFilterResult> forwardRequest(RequestHeaderData header, ApiMessage request) {
            return this.requestFilterResultBuilder().forward((ApiMessage)header, request).completed();
        }

        public CompletionStage<ResponseFilterResult> forwardResponse(ResponseHeaderData header, ApiMessage response) {
            return this.responseFilterResultBuilder().forward((ApiMessage)header, response).completed();
        }

        public <M extends ApiMessage> CompletionStage<M> sendRequest(RequestHeaderData header, ApiMessage request) {
            Objects.requireNonNull(header);
            Objects.requireNonNull(request);
            ApiKeys apiKey = ApiKeys.forId((int)request.apiKey());
            header.setRequestApiKey(apiKey.id);
            header.setCorrelationId(-1);
            if (!apiKey.isVersionSupported(header.requestApiVersion())) {
                throw new IllegalArgumentException("Filter '%s': apiKey %s does not support version %d. the supported version range for this api key is %d...%d (inclusive).".formatted(FilterHandler.this.filterDescriptor(), apiKey, header.requestApiVersion(), apiKey.oldestVersion(), apiKey.latestVersion()));
            }
            boolean hasResponse = apiKey != ApiKeys.PRODUCE || ((ProduceRequestData)request).acks() != 0;
            CompletableFuture filterPromise = FilterHandler.this.promiseFactory.newTimeLimitedPromise(() -> "Asynchronous %s request made by filter '%s' failed to complete within %s ms.".formatted(apiKey, FilterHandler.this.filterDescriptor(), FilterHandler.this.timeoutMs));
            InternalRequestFrame<ApiMessage> frame = new InternalRequestFrame<ApiMessage>(header.requestApiVersion(), header.correlationId(), hasResponse, FilterHandler.this.filterAndInvoker.filter(), filterPromise, header, request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: Filter '{}' sending request: {}", new Object[]{FilterHandler.this.channelDescriptor(), FilterHandler.this.filterDescriptor(), FilterHandler.msgDescriptor(frame)});
            }
            ChannelPromise writePromise = FilterHandler.this.ctx.channel().newPromise();
            FilterHandler.this.ctx.writeAndFlush(frame, writePromise);
            if (!hasResponse) {
                writePromise.addListener(f -> {
                    if (f.isSuccess()) {
                        filterPromise.complete(null);
                    } else {
                        filterPromise.completeExceptionally(f.cause());
                    }
                });
            }
            return filterPromise.minimalCompletionStage();
        }
    }
}

