/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.internal.ProxyChannelStateMachine;
import io.kroxylicious.proxy.model.VirtualClusterModel;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProxyBackendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaProxyBackendHandler.class);
    final ProxyChannelStateMachine proxyChannelStateMachine;
    @Nullable
    final SslContext sslContext;
    @Nullable
    ChannelHandlerContext serverCtx;
    private boolean pendingServerFlushes;

    public KafkaProxyBackendHandler(ProxyChannelStateMachine proxyChannelStateMachine, VirtualClusterModel virtualClusterModel) {
        this.proxyChannelStateMachine = Objects.requireNonNull(proxyChannelStateMachine);
        Optional<SslContext> upstreamSslContext = virtualClusterModel.getUpstreamSslContext();
        this.sslContext = upstreamSslContext.orElse(null);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        if (ctx.channel().isWritable()) {
            this.proxyChannelStateMachine.onServerWritable();
        } else {
            this.proxyChannelStateMachine.onServerUnwritable();
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.serverCtx = ctx;
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.trace("Channel active {}", (Object)ctx);
        if (this.sslContext == null) {
            this.proxyChannelStateMachine.onServerActive();
        }
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent sslEvt = (SslHandshakeCompletionEvent)event;
            if (sslEvt.isSuccess()) {
                this.proxyChannelStateMachine.onServerActive();
            } else {
                this.proxyChannelStateMachine.onServerException(sslEvt.cause());
            }
        }
        super.userEventTriggered(ctx, event);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.proxyChannelStateMachine.onServerInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.proxyChannelStateMachine.onServerException(cause);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.proxyChannelStateMachine.messageFromServer(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        this.proxyChannelStateMachine.serverReadComplete();
    }

    public void forwardToServer(Object msg) {
        if (this.serverCtx == null) {
            this.proxyChannelStateMachine.illegalState("write without outbound active outbound channel");
        } else {
            Channel outboundChannel = this.serverCtx.channel();
            if (outboundChannel.isWritable()) {
                outboundChannel.write(msg, this.serverCtx.voidPromise());
                this.pendingServerFlushes = true;
            } else {
                outboundChannel.writeAndFlush(msg, this.serverCtx.voidPromise());
                this.pendingServerFlushes = false;
            }
        }
        LOGGER.trace("/READ");
    }

    public void flushToServer() {
        if (this.serverCtx != null) {
            Channel serverChannel = this.serverCtx.channel();
            if (this.pendingServerFlushes) {
                this.pendingServerFlushes = false;
                serverChannel.flush();
            }
            if (!serverChannel.isWritable()) {
                this.proxyChannelStateMachine.onServerUnwritable();
            }
        }
    }

    public void applyBackpressure() {
        if (this.serverCtx != null) {
            this.serverCtx.channel().config().setAutoRead(false);
        }
    }

    public void relieveBackpressure() {
        if (this.serverCtx != null) {
            this.serverCtx.channel().config().setAutoRead(true);
        }
    }

    public void inClosed() {
        Channel outboundChannel;
        if (this.serverCtx != null && (outboundChannel = this.serverCtx.channel()).isActive()) {
            outboundChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public String toString() {
        return "KafkaProxyBackendHandler{, serverCtx=" + String.valueOf(this.serverCtx) + ", proxyChannelState=" + this.proxyChannelStateMachine.currentState() + ", pendingServerFlushes=" + this.pendingServerFlushes + "}";
    }
}

