/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import java.util.stream.Collectors;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddRaftVoterRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeDelegationTokenRequestData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.EnvelopeRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.ListClientMetricsResourcesRequestData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListTransactionsRequestData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.RemoveRaftVoterRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareGroupDescribeRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateRaftVoterRequestData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddRaftVoterRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.AssignReplicasToDirsRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteShareGroupStateRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeTopicPartitionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitializeShareGroupStateRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListClientMetricsResourcesRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.PushTelemetryRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryRequest;
import org.apache.kafka.common.requests.RemoveRaftVoterRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareGroupDescribeRequest;
import org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateRaftVoterRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.WriteShareGroupStateRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class KafkaProxyExceptionMapper {
    private KafkaProxyExceptionMapper() {
    }

    public static ApiMessage errorResponseMessage(DecodedRequestFrame<?> frame, Throwable error) {
        return KafkaProxyExceptionMapper.errorResponse(frame, error).data();
    }

    public static AbstractResponse errorResponseForMessage(RequestHeaderData requestHeaders, ApiMessage message, ApiException apiException) {
        short apiKey = message.apiKey();
        return KafkaProxyExceptionMapper.errorResponse(ApiKeys.forId((int)apiKey), message, requestHeaders.requestApiVersion()).getErrorResponse((Throwable)apiException);
    }

    static AbstractResponse errorResponse(DecodedRequestFrame<?> frame, Throwable error) {
        Object reqBody = frame.body();
        short apiVersion = frame.apiVersion();
        ApiKeys apiKey = frame.apiKey();
        AbstractRequest req = KafkaProxyExceptionMapper.errorResponse(apiKey, reqBody, apiVersion);
        return req.getErrorResponse(error);
    }

    private static AbstractRequest errorResponse(ApiKeys apiKey, ApiMessage reqBody, short apiVersion) {
        return switch (apiKey) {
            case ApiKeys.SASL_HANDSHAKE -> new SaslHandshakeRequest((SaslHandshakeRequestData)reqBody, apiVersion);
            case ApiKeys.SASL_AUTHENTICATE -> new SaslAuthenticateRequest((SaslAuthenticateRequestData)reqBody, apiVersion);
            case ApiKeys.PRODUCE -> new ProduceRequest((ProduceRequestData)reqBody, apiVersion);
            case ApiKeys.FETCH -> new FetchRequest((FetchRequestData)reqBody, apiVersion);
            case ApiKeys.LIST_OFFSETS -> {
                ListOffsetsRequestData listOffsetsRequestData = (ListOffsetsRequestData)reqBody;
                if (listOffsetsRequestData.replicaId() == -1) {
                    yield ListOffsetsRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.forId((byte)listOffsetsRequestData.isolationLevel())).setTargetTimes(listOffsetsRequestData.topics()).build(apiVersion);
                }
                yield ListOffsetsRequest.Builder.forReplica((short)apiVersion, (int)listOffsetsRequestData.replicaId()).setTargetTimes(listOffsetsRequestData.topics()).build(apiVersion);
            }
            case ApiKeys.METADATA -> new MetadataRequest((MetadataRequestData)reqBody, apiVersion);
            case ApiKeys.OFFSET_COMMIT -> new OffsetCommitRequest((OffsetCommitRequestData)reqBody, apiVersion);
            case ApiKeys.OFFSET_FETCH -> {
                OffsetFetchRequestData offsetFetchRequestData = (OffsetFetchRequestData)reqBody;
                if (offsetFetchRequestData.groups() != null && !offsetFetchRequestData.groups().isEmpty()) {
                    yield new OffsetFetchRequest.Builder(offsetFetchRequestData.groups().stream().collect(Collectors.toMap(OffsetFetchRequestData.OffsetFetchRequestGroup::groupId, x -> x.topics().stream().flatMap(t -> t.partitionIndexes().stream().map(p -> new TopicPartition(t.name(), p.intValue()))).toList())), true, false).build(apiVersion);
                }
                if (offsetFetchRequestData.topics() != null && !offsetFetchRequestData.topics().isEmpty()) {
                    yield new OffsetFetchRequest.Builder(offsetFetchRequestData.groupId(), offsetFetchRequestData.requireStable(), offsetFetchRequestData.topics().stream().flatMap(x -> x.partitionIndexes().stream().map(p -> new TopicPartition(x.name(), p.intValue()))).toList(), false).build(apiVersion);
                }
                throw new IllegalStateException();
            }
            case ApiKeys.FIND_COORDINATOR -> new FindCoordinatorRequest.Builder((FindCoordinatorRequestData)reqBody).build(apiVersion);
            case ApiKeys.JOIN_GROUP -> new JoinGroupRequest((JoinGroupRequestData)reqBody, apiVersion);
            case ApiKeys.HEARTBEAT -> new HeartbeatRequest.Builder((HeartbeatRequestData)reqBody).build(apiVersion);
            case ApiKeys.LEAVE_GROUP -> {
                LeaveGroupRequestData data = (LeaveGroupRequestData)reqBody;
                yield new LeaveGroupRequest.Builder(data.groupId(), data.members()).build(apiVersion);
            }
            case ApiKeys.SYNC_GROUP -> new SyncGroupRequest((SyncGroupRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_GROUPS -> new DescribeGroupsRequest.Builder((DescribeGroupsRequestData)reqBody).build(apiVersion);
            case ApiKeys.LIST_GROUPS -> new ListGroupsRequest((ListGroupsRequestData)reqBody, apiVersion);
            case ApiKeys.API_VERSIONS -> new ApiVersionsRequest((ApiVersionsRequestData)reqBody, apiVersion);
            case ApiKeys.CREATE_TOPICS -> new CreateTopicsRequest((CreateTopicsRequestData)reqBody, apiVersion);
            case ApiKeys.DELETE_TOPICS -> new DeleteTopicsRequest.Builder((DeleteTopicsRequestData)reqBody).build(apiVersion);
            case ApiKeys.DELETE_RECORDS -> new DeleteRecordsRequest.Builder((DeleteRecordsRequestData)reqBody).build(apiVersion);
            case ApiKeys.INIT_PRODUCER_ID -> new InitProducerIdRequest.Builder((InitProducerIdRequestData)reqBody).build(apiVersion);
            case ApiKeys.OFFSET_FOR_LEADER_EPOCH -> new OffsetsForLeaderEpochRequest((OffsetForLeaderEpochRequestData)reqBody, apiVersion);
            case ApiKeys.ADD_PARTITIONS_TO_TXN -> new AddPartitionsToTxnRequest((AddPartitionsToTxnRequestData)reqBody, apiVersion);
            case ApiKeys.ADD_OFFSETS_TO_TXN -> new AddOffsetsToTxnRequest((AddOffsetsToTxnRequestData)reqBody, apiVersion);
            case ApiKeys.END_TXN -> new EndTxnRequest.Builder((EndTxnRequestData)reqBody, apiVersion > 4).build(apiVersion);
            case ApiKeys.WRITE_TXN_MARKERS -> new WriteTxnMarkersRequest.Builder((WriteTxnMarkersRequestData)reqBody).build(apiVersion);
            case ApiKeys.TXN_OFFSET_COMMIT -> new TxnOffsetCommitRequest((TxnOffsetCommitRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_ACLS -> {
                DescribeAclsRequestData d = (DescribeAclsRequestData)reqBody;
                yield new DescribeAclsRequest.Builder(new AclBindingFilter(new ResourcePatternFilter(ResourceType.fromCode((byte)d.resourceTypeFilter()), d.resourceNameFilter(), PatternType.fromCode((byte)d.patternTypeFilter())), new AccessControlEntryFilter(d.principalFilter(), d.hostFilter(), AclOperation.fromCode((byte)d.operation()), AclPermissionType.fromCode((byte)d.permissionType())))).build(apiVersion);
            }
            case ApiKeys.CREATE_ACLS -> new CreateAclsRequest.Builder((CreateAclsRequestData)reqBody).build(apiVersion);
            case ApiKeys.DELETE_ACLS -> new DeleteAclsRequest.Builder((DeleteAclsRequestData)reqBody).build(apiVersion);
            case ApiKeys.DESCRIBE_CONFIGS -> new DescribeConfigsRequest((DescribeConfigsRequestData)reqBody, apiVersion);
            case ApiKeys.ALTER_CONFIGS -> new AlterConfigsRequest((AlterConfigsRequestData)reqBody, apiVersion);
            case ApiKeys.ALTER_REPLICA_LOG_DIRS -> new AlterReplicaLogDirsRequest((AlterReplicaLogDirsRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_LOG_DIRS -> new DescribeLogDirsRequest((DescribeLogDirsRequestData)reqBody, apiVersion);
            case ApiKeys.CREATE_PARTITIONS -> new CreatePartitionsRequest.Builder((CreatePartitionsRequestData)reqBody).build(apiVersion);
            case ApiKeys.CREATE_DELEGATION_TOKEN -> new CreateDelegationTokenRequest.Builder((CreateDelegationTokenRequestData)reqBody).build(apiVersion);
            case ApiKeys.RENEW_DELEGATION_TOKEN -> new RenewDelegationTokenRequest.Builder((RenewDelegationTokenRequestData)reqBody).build(apiVersion);
            case ApiKeys.EXPIRE_DELEGATION_TOKEN -> new ExpireDelegationTokenRequest.Builder((ExpireDelegationTokenRequestData)reqBody).build(apiVersion);
            case ApiKeys.DESCRIBE_DELEGATION_TOKEN -> {
                DescribeDelegationTokenRequestData tokenRequestData = (DescribeDelegationTokenRequestData)reqBody;
                yield new DescribeDelegationTokenRequest.Builder(tokenRequestData.owners().stream().map(o -> new KafkaPrincipal(o.principalType(), o.principalName())).toList()).build(apiVersion);
            }
            case ApiKeys.DELETE_GROUPS -> new DeleteGroupsRequest((DeleteGroupsRequestData)reqBody, apiVersion);
            case ApiKeys.ELECT_LEADERS -> {
                ElectLeadersRequestData electLeaders = (ElectLeadersRequestData)reqBody;
                yield new ElectLeadersRequest.Builder(ElectionType.valueOf((byte)electLeaders.electionType()), electLeaders.topicPartitions().stream().flatMap(t -> t.partitions().stream().map(p -> new TopicPartition(t.topic(), p.intValue()))).toList(), electLeaders.timeoutMs()).build(apiVersion);
            }
            case ApiKeys.INCREMENTAL_ALTER_CONFIGS -> new IncrementalAlterConfigsRequest((IncrementalAlterConfigsRequestData)reqBody, apiVersion);
            case ApiKeys.ALTER_PARTITION_REASSIGNMENTS -> new AlterPartitionReassignmentsRequest.Builder((AlterPartitionReassignmentsRequestData)reqBody).build(apiVersion);
            case ApiKeys.LIST_PARTITION_REASSIGNMENTS -> new ListPartitionReassignmentsRequest.Builder((ListPartitionReassignmentsRequestData)reqBody).build(apiVersion);
            case ApiKeys.OFFSET_DELETE -> new OffsetDeleteRequest((OffsetDeleteRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_CLIENT_QUOTAS -> new DescribeClientQuotasRequest((DescribeClientQuotasRequestData)reqBody, apiVersion);
            case ApiKeys.ALTER_CLIENT_QUOTAS -> new AlterClientQuotasRequest((AlterClientQuotasRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_USER_SCRAM_CREDENTIALS -> new DescribeUserScramCredentialsRequest.Builder((DescribeUserScramCredentialsRequestData)reqBody).build(apiVersion);
            case ApiKeys.ALTER_USER_SCRAM_CREDENTIALS -> new AlterUserScramCredentialsRequest.Builder((AlterUserScramCredentialsRequestData)reqBody).build(apiVersion);
            case ApiKeys.DESCRIBE_QUORUM -> new DescribeQuorumRequest.Builder((DescribeQuorumRequestData)reqBody).build(apiVersion);
            case ApiKeys.ALTER_PARTITION -> new AlterPartitionRequest((AlterPartitionRequestData)reqBody, apiVersion);
            case ApiKeys.UPDATE_FEATURES -> new UpdateFeaturesRequest((UpdateFeaturesRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_CLUSTER -> new DescribeClusterRequest((DescribeClusterRequestData)reqBody, apiVersion);
            case ApiKeys.DESCRIBE_PRODUCERS -> new DescribeProducersRequest.Builder((DescribeProducersRequestData)reqBody).build(apiVersion);
            case ApiKeys.DESCRIBE_TRANSACTIONS -> new DescribeTransactionsRequest.Builder((DescribeTransactionsRequestData)reqBody).build(apiVersion);
            case ApiKeys.LIST_TRANSACTIONS -> new ListTransactionsRequest.Builder((ListTransactionsRequestData)reqBody).build(apiVersion);
            case ApiKeys.ALLOCATE_PRODUCER_IDS -> new AllocateProducerIdsRequest((AllocateProducerIdsRequestData)reqBody, apiVersion);
            case ApiKeys.VOTE -> new VoteRequest.Builder((VoteRequestData)reqBody).build(apiVersion);
            case ApiKeys.BEGIN_QUORUM_EPOCH -> new BeginQuorumEpochRequest.Builder((BeginQuorumEpochRequestData)reqBody).build(apiVersion);
            case ApiKeys.END_QUORUM_EPOCH -> new EndQuorumEpochRequest.Builder((EndQuorumEpochRequestData)reqBody).build(apiVersion);
            case ApiKeys.ENVELOPE -> new EnvelopeRequest((EnvelopeRequestData)reqBody, apiVersion);
            case ApiKeys.FETCH_SNAPSHOT -> new FetchSnapshotRequest((FetchSnapshotRequestData)reqBody, apiVersion);
            case ApiKeys.BROKER_REGISTRATION -> new BrokerRegistrationRequest((BrokerRegistrationRequestData)reqBody, apiVersion);
            case ApiKeys.BROKER_HEARTBEAT -> new BrokerHeartbeatRequest((BrokerHeartbeatRequestData)reqBody, apiVersion);
            case ApiKeys.UNREGISTER_BROKER -> new UnregisterBrokerRequest((UnregisterBrokerRequestData)reqBody, apiVersion);
            case ApiKeys.CONSUMER_GROUP_HEARTBEAT -> new ConsumerGroupHeartbeatRequest((ConsumerGroupHeartbeatRequestData)reqBody, apiVersion);
            case ApiKeys.CONSUMER_GROUP_DESCRIBE -> new ConsumerGroupDescribeRequest((ConsumerGroupDescribeRequestData)reqBody, apiVersion);
            case ApiKeys.CONTROLLER_REGISTRATION -> new ControllerRegistrationRequest((ControllerRegistrationRequestData)reqBody, apiVersion);
            case ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS -> new GetTelemetrySubscriptionsRequest((GetTelemetrySubscriptionsRequestData)reqBody, apiVersion);
            case ApiKeys.PUSH_TELEMETRY -> new PushTelemetryRequest((PushTelemetryRequestData)reqBody, apiVersion);
            case ApiKeys.ASSIGN_REPLICAS_TO_DIRS -> new AssignReplicasToDirsRequest((AssignReplicasToDirsRequestData)reqBody, apiVersion);
            case ApiKeys.LIST_CLIENT_METRICS_RESOURCES -> new ListClientMetricsResourcesRequest.Builder((ListClientMetricsResourcesRequestData)reqBody).build(apiVersion);
            case ApiKeys.DESCRIBE_TOPIC_PARTITIONS -> new DescribeTopicPartitionsRequest((DescribeTopicPartitionsRequestData)reqBody, apiVersion);
            case ApiKeys.ADD_RAFT_VOTER -> new AddRaftVoterRequest((AddRaftVoterRequestData)reqBody, apiVersion);
            case ApiKeys.REMOVE_RAFT_VOTER -> new RemoveRaftVoterRequest((RemoveRaftVoterRequestData)reqBody, apiVersion);
            case ApiKeys.UPDATE_RAFT_VOTER -> new UpdateRaftVoterRequest((UpdateRaftVoterRequestData)reqBody, apiVersion);
            case ApiKeys.SHARE_GROUP_HEARTBEAT -> new ShareGroupHeartbeatRequest((ShareGroupHeartbeatRequestData)reqBody, apiVersion);
            case ApiKeys.SHARE_GROUP_DESCRIBE -> new ShareGroupDescribeRequest((ShareGroupDescribeRequestData)reqBody, apiVersion);
            case ApiKeys.SHARE_FETCH -> new ShareFetchRequest((ShareFetchRequestData)reqBody, apiVersion);
            case ApiKeys.SHARE_ACKNOWLEDGE -> new ShareAcknowledgeRequest((ShareAcknowledgeRequestData)reqBody, apiVersion);
            case ApiKeys.INITIALIZE_SHARE_GROUP_STATE -> new InitializeShareGroupStateRequest((InitializeShareGroupStateRequestData)reqBody, apiVersion);
            case ApiKeys.READ_SHARE_GROUP_STATE -> new ReadShareGroupStateRequest((ReadShareGroupStateRequestData)reqBody, apiVersion);
            case ApiKeys.WRITE_SHARE_GROUP_STATE -> new WriteShareGroupStateRequest((WriteShareGroupStateRequestData)reqBody, apiVersion);
            case ApiKeys.DELETE_SHARE_GROUP_STATE -> new DeleteShareGroupStateRequest((DeleteShareGroupStateRequestData)reqBody, apiVersion);
            case ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY -> new ReadShareGroupStateSummaryRequest((ReadShareGroupStateSummaryRequestData)reqBody, apiVersion);
            default -> throw new IllegalStateException("Unable to generate error for APIKey: " + String.valueOf(apiKey));
        };
    }
}

