/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.internal.codec.DecodePredicate;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaslDecodePredicate
implements DecodePredicate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaslDecodePredicate.class);
    private final boolean handleSasl;
    @Nullable
    private DecodePredicate delegate = null;

    SaslDecodePredicate(boolean handleSasl) {
        this.handleSasl = handleSasl;
    }

    public void setDelegate(DecodePredicate delegate) {
        LOGGER.debug("Setting delegate {}", (Object)delegate);
        this.delegate = delegate;
    }

    @Override
    public boolean shouldDecodeRequest(ApiKeys apiKey, short apiVersion) {
        if (apiKey == ApiKeys.API_VERSIONS) {
            return true;
        }
        if (this.delegate == null) {
            return true;
        }
        return this.isAuthenticationOffloaded(apiKey) || this.delegate.shouldDecodeRequest(apiKey, apiVersion);
    }

    private boolean isAuthenticationOffloaded(ApiKeys apiKey) {
        return this.isAuthenticationOffloadEnabled() && (apiKey == ApiKeys.SASL_HANDSHAKE || apiKey == ApiKeys.SASL_AUTHENTICATE);
    }

    public boolean isAuthenticationOffloadEnabled() {
        return this.handleSasl;
    }

    @Override
    public boolean shouldDecodeResponse(ApiKeys apiKey, short apiVersion) {
        return this.delegate == null || this.delegate.shouldDecodeResponse(apiKey, apiVersion);
    }

    public String toString() {
        return "SaslDecodePredicate(handleSasl=" + this.handleSasl + ", delegate=" + String.valueOf(this.delegate) + ")";
    }
}

